<?php
/**
 * Header Layout
 * @package Skin Care Solutions
 */

$skin_care_solutions_default = skin_care_solutions_get_default_theme_options();

$header_layout_phone_number = esc_html( get_theme_mod( 'skin_care_solutions_header_layout_phone_number',
$skin_care_solutions_default['skin_care_solutions_header_layout_phone_number'] ) );

$header_layout_20_per_discount_text = esc_html( get_theme_mod( 'skin_care_solutions_header_layout_20_per_discount_text',
$skin_care_solutions_default['skin_care_solutions_header_layout_20_per_discount_text'] ) );

$skin_care_solutions_header_layout_facebook_link = esc_url( get_theme_mod( 'skin_care_solutions_header_layout_facebook_link',
$skin_care_solutions_default['skin_care_solutions_header_layout_facebook_link'] ) );


$skin_care_solutions_header_layout_twitter_link = esc_url( get_theme_mod( 'skin_care_solutions_header_layout_twitter_link',
$skin_care_solutions_default['skin_care_solutions_header_layout_twitter_link'] ) );


$skin_care_solutions_header_layout_pintrest_link = esc_url( get_theme_mod( 'skin_care_solutions_header_layout_pintrest_link',
$skin_care_solutions_default['skin_care_solutions_header_layout_pintrest_link'] ) );


$skin_care_solutions_header_layout_instagram_link = esc_url( get_theme_mod( 'skin_care_solutions_header_layout_instagram_link',
$skin_care_solutions_default['skin_care_solutions_header_layout_instagram_link'] ) );


$skin_care_solutions_header_layout_youtube_link = esc_url( get_theme_mod( 'skin_care_solutions_header_layout_youtube_link',
$skin_care_solutions_default['skin_care_solutions_header_layout_youtube_link'] ) );

$skin_care_solutions_sticky = get_theme_mod('skin_care_solutions_sticky');
$skin_care_solutions_data_sticky = "false";
if ($skin_care_solutions_sticky) {
$skin_care_solutions_data_sticky = "true";
}
global $wp_customize;

?>

<section id="top-header">
    <div class="wrapper header-wrapper">
        <div class="theme-header-areas header-areas-left">
            <?php if( $header_layout_phone_number ){ ?>
               <span class="call-header"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--!Font Awesome Free 6.5.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M497.4 361.8l-112-48a24 24 0 0 0 -28 6.9l-49.6 60.6A370.7 370.7 0 0 1 130.6 204.1l60.6-49.6a23.9 23.9 0 0 0 6.9-28l-48-112A24.2 24.2 0 0 0 122.6 .6l-104 24A24 24 0 0 0 0 48c0 256.5 207.9 464 464 464a24 24 0 0 0 23.4-18.6l24-104a24.3 24.3 0 0 0 -14-27.6z"/></svg><?php echo esc_html( 'For any question call us at ' ); ?><a href="tell:<?php echo esc_html( $header_layout_phone_number ); ?>"><?php echo esc_html( $header_layout_phone_number ); ?></a></span>
            <?php } ?>
        </div>
        <div class="theme-header-areas header-areas-right">
            <?php if( $header_layout_20_per_discount_text ){ ?>
               <span><?php echo esc_html( $header_layout_20_per_discount_text ); ?></span>
            <?php } ?>
        </div>
        <div class="theme-header-areas header-areas-right">
            <div class="social-area">
                <?php if( $skin_care_solutions_header_layout_facebook_link ){ ?>
                   <a target="_blank" href="<?php echo esc_url( $skin_care_solutions_header_layout_facebook_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc. --><path d="M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z"/></svg></a>
                <?php } ?>
                <?php if( $skin_care_solutions_header_layout_twitter_link ){ ?>
                   <a target="_blank" href="<?php echo esc_url( $skin_care_solutions_header_layout_twitter_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc. --><path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"/></svg></a>
                <?php } ?>
                <?php if( $skin_care_solutions_header_layout_pintrest_link ){ ?>
                   <a target="_blank" href="<?php echo esc_url( $skin_care_solutions_header_layout_pintrest_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 384 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc. --><path d="M204 6.5C101.4 6.5 0 74.9 0 185.6 0 256 39.6 296 63.6 296c9.9 0 15.6-27.6 15.6-35.4 0-9.3-23.7-29.1-23.7-67.8 0-80.4 61.2-137.4 140.4-137.4 68.1 0 118.5 38.7 118.5 109.8 0 53.1-21.3 152.7-90.3 152.7-24.9 0-46.2-18-46.2-43.8 0-37.8 26.4-74.4 26.4-113.4 0-66.2-93.9-54.2-93.9 25.8 0 16.8 2.1 35.4 9.6 50.7-13.8 59.4-42 147.9-42 209.1 0 18.9 2.7 37.5 4.5 56.4 3.4 3.8 1.7 3.4 6.9 1.5 50.4-69 48.6-82.5 71.4-172.8 12.3 23.4 44.1 36 69.3 36 106.2 0 153.9-103.5 153.9-196.8C384 71.3 298.2 6.5 204 6.5z"/></svg></a>
                <?php } ?>
                <?php if( $skin_care_solutions_header_layout_instagram_link ){ ?>
                   <a target="_blank" href="<?php echo esc_url( $skin_care_solutions_header_layout_instagram_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc. --><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"/></svg></a>
                <?php } ?>
                <?php if( $skin_care_solutions_header_layout_youtube_link ){ ?>
                   <a target="_blank" href="<?php echo esc_url( $skin_care_solutions_header_layout_youtube_link ); ?>"><svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 576 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc. --><path d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z"/></svg></a>
                <?php } ?>
            </div>
        </div>
    </div>
</section>

<section id="center-header" class="center-headers <?php if( is_user_logged_in() && !isset( $wp_customize ) ){ echo "login-user";} ?>" data-sticky="<?php echo esc_attr($skin_care_solutions_data_sticky); ?>">
    <div class="wrapper header-wrapper">
        <div class="theme-header-areas header-areas-right">
            <div class="header-titles">
                <?php
                    skin_care_solutions_site_logo();
                    skin_care_solutions_site_description();
                ?>
            </div>
        </div>
        <div class="theme-header-areas header-areas-right">
            <div class="site-navigation">
                <nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e('Horizontal', 'skin-care-solutions'); ?>" role="navigation">
                    <ul class="primary-menu theme-menu">
                        <?php
                        if (has_nav_menu('skin-care-solutions-primary-menu')) {
                            wp_nav_menu(
                                array(
                                    'container' => '',
                                    'items_wrap' => '%3$s',
                                    'theme_location' => 'skin-care-solutions-primary-menu',
                                )
                            );
                        } else {
                            wp_list_pages(
                                array(
                                    'match_menu_classes' => true,
                                    'show_sub_menu_icons' => true,
                                    'title_li' => false,
                                    'walker' => new Skin_Care_Solutions_Walker_Page(),
                                )
                            );
                        } ?>
                    </ul>
                </nav>
            </div>
            <div class="navbar-controls twp-hide-js">
                <button type="button" class="navbar-control navbar-control-offcanvas">
                    <span class="navbar-control-trigger" tabindex="-1">
                        <?php skin_care_solutions_the_theme_svg('menu'); ?>
                    </span>
                </button>
            </div>
        </div>
        <div class="theme-header-areas header-areas-right">
           <div class="header-search">
                <?php if(class_exists('woocommerce')){ ?>
                    <?php get_product_search_form(); ?>
                <?php }?>
           </div>
        </div>
    </div>
</section>