<?php
/**
 * Footer Widget Template
 *
 * Please do not edit this file. This file is part of the CyberChimps Framework and all modifications
 * should be made in a child theme.
 *
 * @category CyberChimps Framework
 * @package  Framework
 * @since    1.0
 * @author   CyberChimps
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     http://www.cyberchimps.com/
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

Responsive\responsive_widgets_before(); // above widgets container hook.
$footer_widgets_columns = get_theme_mod( 'responsive_footer_widgets_columns' );

if ( $footer_widgets_columns ) :
	?>

	<div id="footer-widgets" class="footer-widgets grid col-940">
		<div class="content-outer container">
			<div class="row">
			<?php
			Responsive\responsive_widgets(); // above widgets hook.

			?>
			<?php
			for ( $i = 1;  $i <= $footer_widgets_columns; $i++ ) {
				if ( is_active_sidebar( 'footer-widget-' . $i ) ) :
					echo '<div class="footer-widget footer-widget-' . esc_html( $i ) . '">';
						dynamic_sidebar( 'footer-widget-' . $i );
					echo '</div>';
				endif; // End of colophon-widget.
			}

			Responsive\responsive_widgets_end(); // after widgets hook.
			?>
			</div>
		</div>
	</div><!-- end of #footer-widget -->
	<?php
endif;

Responsive\responsive_widgets_after(); // after widgets container hook. ?>
