<?php

/**
* Get started notice
*/

add_action( 'wp_ajax_fitness_coaching_dismissed_notice_handler', 'fitness_coaching_ajax_notice_handler' );

/**
 * AJAX handler to store the state of dismissible notices.
 */
function fitness_coaching_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        // Pick up the notice "type" - passed via jQuery (the "data-notice" attribute on the notice)
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        // Store it in the options table
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function fitness_coaching_deprecated_hook_admin_notice() {
        // Check if it's been dismissed...
        if ( ! get_option('dismissed-get_started', FALSE ) ) {?>

            <?php
            $current_screen = get_current_screen();
				if ($current_screen->id !== 'appearance_page_fitness-coaching-guide-page') {
             $fitness_coaching_comments_theme = wp_get_theme(); ?>
            <div class="fitness-coaching-notice-wrapper updated notice notice-get-started-class is-dismissible" data-notice="get_started">
			<div class="fitness-coaching-notice">
				<div class="fitness-coaching-notice-img">
					<img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/admin-logo.png'); ?>" alt="<?php esc_attr_e('logo', 'fitness-coaching'); ?>">
				</div>
				<div class="fitness-coaching-notice-content">
					<div class="fitness-coaching-notice-heading"><?php esc_html_e('Thanks for installing ','fitness-coaching'); ?><?php echo esc_html( $fitness_coaching_comments_theme ); ?></div>
					<p><?php printf(__('In order to fully benefit from everything our theme has to offer, please make sure you visit our <a href="%s">For Premium Options</a>.', 'fitness-coaching'), esc_url(admin_url('themes.php?page=fitness-coaching-guide-page'))); ?></p>
					<?php if (is_child_theme()) { ?>
						<?php $child_theme = wp_get_theme(); ?>
						<?php printf(esc_html__('You\'re using %1$s theme, It\'s a child theme of %2$s.', 'fitness-coaching'), '<strong>' . $child_theme->Name . '</strong>', '<strong>' . esc_html__('fitness_coaching', 'fitness-coaching') . '</strong>'); 
						?>
						<?php
						$copy_link_args = array(
							'page' => 'fitness-coaching',
							'action' => 'show_copy_settings',
						);
						$copy_link = add_query_arg($copy_link_args, admin_url('themes.php'));
						?>
						<?php printf('%s <a href="%s" class="go-to-setting">%s</a>', esc_html__('Now you can copy setting data from parent theme to this child theme', 'fitness-coaching'), esc_url($copy_link), esc_html__('Copy Settings', 'fitness-coaching')); ?>
					<?php } ?>
				</div>
			</div>
		</div>
        <?php }
	}
}

add_action( 'admin_notices', 'fitness_coaching_deprecated_hook_admin_notice' );

add_action( 'admin_menu', 'fitness_coaching_getting_started' );
function fitness_coaching_getting_started() {    	    	
	add_theme_page( esc_html__('Get Started', 'fitness-coaching'), esc_html__('Get Started', 'fitness-coaching'), 'edit_theme_options', 'fitness-coaching-guide-page', 'fitness_coaching_test_guide');   
}

function fitness_coaching_admin_enqueue_scripts() {
	wp_enqueue_style( 'fitness-coaching-admin-style', esc_url( get_template_directory_uri() ).'/css/main.css' );
	wp_enqueue_script( 'fitness-coaching-admin-script', get_template_directory_uri() . '/js/fitness-coaching-admin-script.js', array( 'jquery' ), '', true );
    wp_localize_script( 'fitness-coaching-admin-script', 'fitness_coaching_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
}
add_action( 'admin_enqueue_scripts', 'fitness_coaching_admin_enqueue_scripts' );

if ( ! defined( 'FITNESS_COACHING_DOCS_FREE' ) ) {
define('FITNESS_COACHING_DOCS_FREE',__('https://www.misbahwp.com/docs/fitness-coaching-free-docs/','fitness-coaching'));
}
if ( ! defined( 'FITNESS_COACHING_DOCS_PRO' ) ) {
define('FITNESS_COACHING_DOCS_PRO',__('https://www.misbahwp.com/docs/fitness-coaching-pro-docs','fitness-coaching'));
}
if ( ! defined( 'FITNESS_COACHING_BUY_NOW' ) ) {
define('FITNESS_COACHING_BUY_NOW',__('https://www.misbahwp.com/themes/fitness-coaching-wordpress-theme/','fitness-coaching'));
}
if ( ! defined( 'FITNESS_COACHING_SUPPORT_FREE' ) ) {
define('FITNESS_COACHING_SUPPORT_FREE',__('https://wordpress.org/support/theme/fitness-coaching','fitness-coaching'));
}
if ( ! defined( 'FITNESS_COACHING_REVIEW_FREE' ) ) {
define('FITNESS_COACHING_REVIEW_FREE',__('https://wordpress.org/support/theme/fitness-coaching/reviews/#new-post','fitness-coaching'));
}
if ( ! defined( 'FITNESS_COACHING_DEMO_PRO' ) ) {
define('FITNESS_COACHING_DEMO_PRO',__('https://www.misbahwp.com/demo/fitness-coaching/','fitness-coaching'));
}
if( ! defined( 'FITNESS_COACHING_THEME_BUNDLE' ) ) {
define('FITNESS_COACHING_THEME_BUNDLE',__('https://www.misbahwp.com/themes/wordpress-bundle/','fitness-coaching'));
}

function fitness_coaching_test_guide() { ?>
	<?php $theme = wp_get_theme(); ?>
	<div class="wrap" id="main-page">
		<div id="lefty">
			<div id="admin_links">
				<a href="<?php echo esc_url( FITNESS_COACHING_DOCS_FREE ); ?>" target="_blank" class="blue-button-1"><?php esc_html_e( 'Documentation', 'fitness-coaching' ) ?></a>			
				<a href="<?php echo esc_url( admin_url('customize.php') ); ?>" id="customizer" target="_blank"><?php esc_html_e( 'Customize', 'fitness-coaching' ); ?> </a>
				<a class="blue-button-1" href="<?php echo esc_url( FITNESS_COACHING_SUPPORT_FREE ); ?>" target="_blank" class="btn3"><?php esc_html_e( 'Support', 'fitness-coaching' ) ?></a>
				<a class="blue-button-2" href="<?php echo esc_url( FITNESS_COACHING_REVIEW_FREE ); ?>" target="_blank" class="btn4"><?php esc_html_e( 'Review', 'fitness-coaching' ) ?></a>
			</div>
			<div id="description">
				<h3><?php esc_html_e('Welcome! Thank you for choosing ','fitness-coaching'); ?><?php echo esc_html( $theme ); ?>  <span><?php esc_html_e('Version: ', 'fitness-coaching'); ?><?php echo esc_html($theme['Version']);?></span></h3>
				<img class="img_responsive" style="width:100%;" src="<?php echo esc_url( get_template_directory_uri() ); ?>/screenshot.png">
				<div id="description-insidee">
					<?php
						$theme = wp_get_theme();
						echo wp_kses_post( apply_filters( 'misbah_theme_description', esc_html( $theme->get( 'Description' ) ) ) );
					?>
				</div>
			</div>
		</div>

		<div id="righty">
			<div class="postboxx donate">
				<h3 class="hndle"><?php esc_html_e( 'Upgrade to Premium', 'fitness-coaching' ); ?></h3>
				<div class="insidee">
					<p><?php esc_html_e('Discover upgraded pro features with premium version click to upgrade.','fitness-coaching'); ?></p>
					<div id="admin_pro_links">
						<a class="blue-button-2" href="<?php echo esc_url( FITNESS_COACHING_BUY_NOW ); ?>" target="_blank"><?php esc_html_e( 'Go Pro', 'fitness-coaching' ); ?></a>
						<a class="blue-button-1" href="<?php echo esc_url( FITNESS_COACHING_DEMO_PRO ); ?>" target="_blank"><?php esc_html_e( 'Live Demo', 'fitness-coaching' ) ?></a>
						<a class="blue-button-2" href="<?php echo esc_url( FITNESS_COACHING_DOCS_PRO ); ?>" target="_blank"><?php esc_html_e( 'Pro Docs', 'fitness-coaching' ) ?></a>
					</div>
				</div>

				<h3 class="hndle bundle"><?php esc_html_e( 'Go For Theme Bundle', 'fitness-coaching' ); ?></h3>
				<div class="insidee theme-bundle">
					<p class="offer"><?php esc_html_e('Get 80+ Perfect WordPress Theme In A Single Package at just $79."','fitness-coaching'); ?></p>
					<p class="coupon"><?php esc_html_e('Exclusive Offer !! Get Our Theme Pack of 60+ WordPress Themes At 10% Off','fitness-coaching'); ?><span class="coupon-code"><?php esc_html_e('"Themespack10"','fitness-coaching'); ?></span></p>
					<div id="admin_pro_linkss">
						<a class="blue-button-1" href="<?php echo esc_url( FITNESS_COACHING_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e( 'Theme Bundle', 'fitness-coaching' ) ?></a>
					</div>
				</div>
				<div class="d-table">
			    <ul class="d-column">
			      <li class="feature"><?php esc_html_e('Features','fitness-coaching'); ?></li>
			      <li class="free"><?php esc_html_e('Pro','fitness-coaching'); ?></li>
			      <li class="plus"><?php esc_html_e('Free','fitness-coaching'); ?></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('24hrs Priority Support','fitness-coaching'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Kirki Framework','fitness-coaching'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Posttype','fitness-coaching'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('One Click Demo Import','fitness-coaching'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Reordering','fitness-coaching'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Enable / Disable Option','fitness-coaching'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Multiple Sections','fitness-coaching'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Color Pallete','fitness-coaching'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Widgets','fitness-coaching'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Page Templates','fitness-coaching'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Typography','fitness-coaching'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Background Image / Color ','fitness-coaching'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>		    
	  		</div>
			</div>
		</div>
	</div>

<?php } ?>
