<?php
/**
 * Template Name: Custom Home Page
 */

get_header(); 

?>

<main role="main" id="skip_content">

  <?php do_action( 'gym_training_coach_above_slider' ); ?>

  <?php if( get_theme_mod('gym_training_coach_slider_hide', false) != '' || get_theme_mod( 'gym_training_coach_display_slider',true) != ''){ ?>
    <section id="slider" class="mw-100 m-auto p-0">
      <div id="carouselExampleCaptions" class="carousel slide" data-bs-ride="carousel"> 
        <?php $gym_training_coach_slider_page = array();
          for ( $gym_training_coach_count = 1; $gym_training_coach_count <= 4; $gym_training_coach_count++ ) {
            $gym_training_coach_mod = intval( get_theme_mod( 'gym_training_coach_slider' . $gym_training_coach_count ));
            if ( 'page-none-selected' != $gym_training_coach_mod ) {
              $gym_training_coach_slider_page[] = $gym_training_coach_mod;
            }
          }
          if( !empty($gym_training_coach_slider_page) ) :
          $gym_training_coach_args = array(
            'post_type' => 'page',
            'post__in' => $gym_training_coach_slider_page,
            'orderby' => 'post__in'
          );
          $gym_training_coach_query = new WP_Query( $gym_training_coach_args );
          if ( $gym_training_coach_query->have_posts() ) :
            $i = 1;
        ?>     
          <div class="carousel-inner" role="listbox">
          <?php  while ( $gym_training_coach_query->have_posts() ) : $gym_training_coach_query->the_post(); ?>
            <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
              <div class="slider-bg">
                <?php if(has_post_thumbnail()){
                  the_post_thumbnail();
                } else{?>
                  <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/slider.png" alt="" />
                <?php } ?>
              </div>
              <div class="carousel-caption">
                <div class="inner_carousel">
                  <div class="carousel-content">
                    <?php if( get_theme_mod('gym_training_coach_slider_small_title') != '' ){ ?>
                      <div class="mb-1">
                        <span class="slider-badge mb-1"><?php echo esc_html(get_theme_mod('gym_training_coach_slider_small_title',''));?></span>
                      </div>
                    <?php }?>
                    <?php if( get_theme_mod('gym_training_coach_slider_heading',true) != ''){ ?>
                      <h1><?php the_title(); ?></h1>
                    <?php } ?>
                    <?php if( get_theme_mod('gym_training_coach_slider_text',true) != ''){ ?>
                      <p class="my-3"><?php $gym_training_coach_excerpt = get_the_excerpt(); echo esc_html( gym_training_coach_string_limit_words( $gym_training_coach_excerpt, esc_attr(get_theme_mod('gym_training_coach_slider_excerpt_number','20')))); ?></p>
                    <?php } ?>
                    <?php if (get_theme_mod( 'gym_training_coach_show_slider_button',true) != ''){ ?>
                      <?php if( get_theme_mod('gym_training_coach_slider_button_text','Get Started') != '' || get_theme_mod('gym_training_coach_slider_button_link') != ''){ ?>
                        <div class="more-btn mt-0 mt-lg-3 mt-md-3">
                          <a href="<?php echo esc_url(get_theme_mod('gym_training_coach_slider_button_link')!= '') ? esc_url(get_theme_mod('gym_training_coach_slider_button_link')) : esc_url(get_permalink()); ?>"><?php echo esc_html( get_theme_mod('gym_training_coach_slider_button_text',__('Get Started','gym-training-coach'))); ?><span class="screen-reader-text"><?php echo esc_html( get_theme_mod('gym_training_coach_slider_button_text',__('Find Your Home','gym-training-coach'))); ?></span></a>
                        </div>
                      <?php }?>
                    <?php } ?>
                  </div>
                </div>
              </div>
            </div>
          <?php $i++; endwhile; 
          wp_reset_postdata();?>
        </div>
        <?php else : ?>
          <div class="no-postfound"></div>
        <?php endif;
        endif;?>
        <a class="carousel-control-prev" data-bs-target="#carouselExampleCaptions" data-bs-slide="prev" role="button">
          <span class="carousel-control-prev-icon w-auto h-auto" aria-hidden="true"><i class="<?php echo esc_attr(get_theme_mod('gym_training_coach_slider_previous_icon','fas fa-arrow-left')); ?>" ></i></span>
          <span class="screen-reader-text"><?php esc_html_e( 'Previous','gym-training-coach' );?></span>
        </a>
        <a class="carousel-control-next" data-bs-target="#carouselExampleCaptions" data-bs-slide="next" role="button">
          <span class="carousel-control-next-icon w-auto h-auto" aria-hidden="true"><i class="<?php echo esc_attr(get_theme_mod('gym_training_coach_slider_next_icon','fas fa-arrow-right')); ?>" ></i></span>
          <span class="screen-reader-text"><?php esc_html_e( 'Next','gym-training-coach' );?></span>
        </a>
      </div>  
      <div class="clearfix"></div>
    </section>
  <?php }?>
  
  <?php do_action( 'gym_training_coach_below_slider' ); ?>

  <?php if( get_theme_mod( 'gym_training_coach_product_enable',false) != false) { ?>
    <section id="our-classes-section" class="py-5">
      <div class="container">
        <div class="events-head">
          <?php if(get_theme_mod('gym_training_coach_section_title') != '') {?>
            <h2 class="text-center"><?php echo esc_html(get_theme_mod('gym_training_coach_section_title')); ?></h2>
          <?php }?>
          <?php if(get_theme_mod('gym_training_coach_section_text') != '') {?>
            <p class="text-center mb-3"><?php echo esc_html(get_theme_mod('gym_training_coach_section_text')); ?></p>
          <?php }?>
        </div>
      
          <div class="owl-carousel">
            <?php if ( get_theme_mod('gym_training_coach_events_category') != '' ) {
              $gym_training_coach_page_query = new WP_Query(array( 'category_name' => esc_html(get_theme_mod('gym_training_coach_events_category')))); ?>
              <?php while( $gym_training_coach_page_query->have_posts() ) : $gym_training_coach_page_query->the_post(); ?>
                <div class="events-box">
                  <?php the_post_thumbnail(); ?>
                  <div class="box-icon"><i class="fas fa-bicycle"></i></div>
                  <div class="events-content">
                    <h3><?php the_title(); ?></h3>
                    <p><?php $gym_training_coach_excerpt = get_the_excerpt(); echo esc_html( gym_training_coach_string_limit_words( $gym_training_coach_excerpt, 12)); ?></p>
                    <div class="mt-2">
                      <a href="<?php the_permalink(); ?>" class="read-more"><?php echo esc_html('Read More', 'gym-training-coach'); ?> <i class="fas fa-arrow-right ms-2"></i><span class="screen-reader-text"><?php echo esc_html('Read More', 'gym-training-coach'); ?></span></a>
                    </div>
                  </div>
                </div>
              <?php endwhile; wp_reset_query(); ?>
            <?php } ?>
          </div>
      </div>
    </section>
  <?php } ?> 

  <div class="container front-page-content">
    <?php while ( have_posts() ) : the_post(); ?>
      <div class="new-text"><?php the_content(); ?></div>
    <?php endwhile; // end of the loop. ?>
  </div>
</main>

<?php get_footer(); ?>