<?php
/**
 * Nutrition Diet: Customizer
 *
 * @subpackage Nutrition Diet
 * @since 1.0
 */

function nutrition_diet_customize_register( $wp_customize ) {

	wp_enqueue_style('customizercustom_css', esc_url( get_template_directory_uri() ). '/assets/css/customizer.css');

	// fontawesome icon-picker

	load_template( trailingslashit( get_template_directory() ) . '/inc/icon-picker.php' );

	// Add custom control.
  	require get_parent_theme_file_path( 'inc/switch/control_switch.php' );

  	require get_parent_theme_file_path( 'inc/custom-control.php' );

  	//Register the sortable control type.
	$wp_customize->register_control_type( 'Nutrition_Diet_Control_Sortable' );

  	// Add homepage customizer file
  	require get_template_directory() . '/inc/customizer-home-page.php';

  	// pro section
 	$wp_customize->add_section('nutrition_diet_pro', array(
        'title'    => __('UPGRADE NUTRITION DIET PREMIUM', 'nutrition-diet'),
        'priority' => 1,
    ));
    $wp_customize->add_setting('nutrition_diet_pro', array(
        'default'           => null,
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control(new Nutrition_Diet_Pro_Control($wp_customize, 'nutrition_diet_pro', array(
        'label'    => __('NUTRITION DIET PREMIUM', 'nutrition-diet'),
        'section'  => 'nutrition_diet_pro',
        'settings' => 'nutrition_diet_pro',
        'priority' => 1,
    )));

    //Logo
    $wp_customize->add_setting('nutrition_diet_logo_max_height',array(
		'default'=> '100',
		'transport' => 'refresh',
		'sanitize_callback' => 'nutrition_diet_sanitize_integer'
	));
	$wp_customize->add_control(new Nutrition_Diet_Slider_Custom_Control( $wp_customize, 'nutrition_diet_logo_max_height',array(
		'label'	=> esc_html__('Logo Width','nutrition-diet'),
		'section'=> 'title_tagline',
		'settings'=>'nutrition_diet_logo_max_height',
		'input_attrs' => array(
			'reset'            => 100,
            'step'             => 1,
			'min'              => 0,
			'max'              => 250,
        ),
	)));
	$wp_customize->add_setting('nutrition_diet_logo_title',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_logo_title',
			array(
				'settings'        => 'nutrition_diet_logo_title',
				'section'         => 'title_tagline',
				'label'           => __( 'Show Site Title', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('nutrition_diet_logo_text',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => 'off',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_logo_text',
			array(
				'settings'        => 'nutrition_diet_logo_text',
				'section'         => 'title_tagline',
				'label'           => __( 'Show Site Tagline', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);

  	// typography
	$wp_customize->add_section( 'nutrition_diet_typography_settings', array(
		'title'       => __( 'Typography Settings', 'nutrition-diet' ),
		'priority'       => 2,
	) );
	$font_choices = array(
		'' => 'Select',
		'Source Sans Pro:400,700,400italic,700italic' => 'Source Sans Pro',
		'Open Sans:400italic,700italic,400,700' => 'Open Sans',
		'Oswald:400,700' => 'Oswald',
		'Playfair Display:400,700,400italic' => 'Playfair Display',
		'Montserrat:400,700' => 'Montserrat',
		'Raleway:400,700' => 'Raleway',
		'Droid Sans:400,700' => 'Droid Sans',
		'Lato:400,700,400italic,700italic' => 'Lato',
		'Arvo:400,700,400italic,700italic' => 'Arvo',
		'Lora:400,700,400italic,700italic' => 'Lora',
		'Merriweather:400,300italic,300,400italic,700,700italic' => 'Merriweather',
		'Oxygen:400,300,700' => 'Oxygen',
		'PT Serif:400,700' => 'PT Serif',
		'PT Sans:400,700,400italic,700italic' => 'PT Sans',
		'PT Sans Narrow:400,700' => 'PT Sans Narrow',
		'Cabin:400,700,400italic' => 'Cabin',
		'Fjalla One:400' => 'Fjalla One',
		'Francois One:400' => 'Francois One',
		'Josefin Sans:400,300,600,700' => 'Josefin Sans',
		'Libre Baskerville:400,400italic,700' => 'Libre Baskerville',
		'Arimo:400,700,400italic,700italic' => 'Arimo',
		'Ubuntu:400,700,400italic,700italic' => 'Ubuntu',
		'Bitter:400,700,400italic' => 'Bitter',
		'Droid Serif:400,700,400italic,700italic' => 'Droid Serif',
		'Roboto:400,400italic,700,700italic' => 'Roboto',
		'Open Sans Condensed:700,300italic,300' => 'Open Sans Condensed',
		'Roboto Condensed:400italic,700italic,400,700' => 'Roboto Condensed',
		'Roboto Slab:400,700' => 'Roboto Slab',
		'Yanone Kaffeesatz:400,700' => 'Yanone Kaffeesatz',
		'Rokkitt:400' => 'Rokkitt',
	);
	$wp_customize->add_setting( 'nutrition_diet_section_typo_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_typo_heading', array(
		'label'       => esc_html__( 'Typography Settings', 'nutrition-diet' ),
		'section'     => 'nutrition_diet_typography_settings',
		'settings'    => 'nutrition_diet_section_typo_heading',
	) ) );
	$wp_customize->add_setting( 'nutrition_diet_headings_text', array(
		'sanitize_callback' => 'nutrition_diet_sanitize_fonts',
	));
	$wp_customize->add_control( 'nutrition_diet_headings_text', array(
		'type' => 'select',
		'description' => __('Select your suitable font for the headings.', 'nutrition-diet'),
		'section' => 'nutrition_diet_typography_settings',
		'choices' => $font_choices
	));
	$wp_customize->add_setting( 'nutrition_diet_body_text', array(
		'sanitize_callback' => 'nutrition_diet_sanitize_fonts'
	));
	$wp_customize->add_control( 'nutrition_diet_body_text', array(
		'type' => 'select',
		'description' => __( 'Select your suitable font for the body.', 'nutrition-diet' ),
		'section' => 'nutrition_diet_typography_settings',
		'choices' => $font_choices
	) );

    // Theme General Settings
    $wp_customize->add_section('nutrition_diet_theme_settings',array(
        'title' => __('Theme General Settings', 'nutrition-diet'),
        'priority' => 3,
    ) );
    $wp_customize->add_setting( 'nutrition_diet_section_sticky_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_sticky_heading', array(
		'label'       => esc_html__( 'Sticky Header Settings', 'nutrition-diet' ),
		'section'     => 'nutrition_diet_theme_settings',
		'settings'    => 'nutrition_diet_section_sticky_heading',
	) ) );
    $wp_customize->add_setting(
		'nutrition_diet_sticky_header',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => 'off',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_sticky_header',
			array(
				'settings'        => 'nutrition_diet_sticky_header',
				'section'         => 'nutrition_diet_theme_settings',
				'label'           => __( 'Show Sticky Header', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'nutrition_diet_section_loader_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_loader_heading', array(
		'label'       => esc_html__( 'Loader Settings', 'nutrition-diet' ),
		'section'     => 'nutrition_diet_theme_settings',
		'settings'    => 'nutrition_diet_section_loader_heading',
	) ) );
	$wp_customize->add_setting(
		'nutrition_diet_theme_loader',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => 'off',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_theme_loader',
			array(
				'settings'        => 'nutrition_diet_theme_loader',
				'section'         => 'nutrition_diet_theme_settings',
				'label'           => __( 'Show Site Loader', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);

	$wp_customize->add_setting('nutrition_diet_loader_style',array(
        'default' => 'style_one',
        'sanitize_callback' => 'nutrition_diet_sanitize_choices'
	));
	$wp_customize->add_control('nutrition_diet_loader_style',array(
        'type' => 'select',
        'label' => __('Select Loader Design','nutrition-diet'),
        'section' => 'nutrition_diet_theme_settings',
        'choices' => array(
            'style_one' => __('Circle','nutrition-diet'),
            'style_two' => __('Bar','nutrition-diet'),
        ),
	) );
	
	$wp_customize->add_setting( 'nutrition_diet_section_theme_width_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_theme_width_heading', array(
		'label'       => esc_html__( 'Theme Width Settings', 'nutrition-diet' ),
		'section'     => 'nutrition_diet_theme_width_settings',
		'settings'    => 'nutrition_diet_section_theme_width_heading',
	) ) );
	$wp_customize->add_setting('nutrition_diet_width_options',array(
        'default' => 'full_width',
        'sanitize_callback' => 'nutrition_diet_sanitize_choices'
	));
	$wp_customize->add_control('nutrition_diet_width_options',array(
        'type' => 'select',
        'label' => __('Theme Width Option','nutrition-diet'),
        'section' => 'nutrition_diet_theme_width_settings',
        'choices' => array(
            'full_width' => __('Fullwidth','nutrition-diet'),
            'container' => __('Container','nutrition-diet'),
            'container_fluid' => __('Container Fluid','nutrition-diet'),
        ),
	) );
	$wp_customize->add_setting( 'nutrition_diet_section_menu_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_menu_heading', array(
		'label'       => esc_html__( 'Menu Settings', 'nutrition-diet' ),
		'section'     => 'nutrition_diet_theme_settings',
		'settings'    => 'nutrition_diet_section_menu_heading',
	) ) );
	$wp_customize->add_setting('nutrition_diet_menu_text_transform',array(
        'default' => 'CAPITALISE',
        'sanitize_callback' => 'nutrition_diet_sanitize_choices'
	));
	$wp_customize->add_control('nutrition_diet_menu_text_transform',array(
        'type' => 'select',
        'label' => __('Menus Text Transform','nutrition-diet'),
        'section' => 'nutrition_diet_theme_settings',
        'choices' => array(
            'CAPITALISE' => __('CAPITALISE','nutrition-diet'),
            'UPPERCASE' => __('UPPERCASE','nutrition-diet'),
            'LOWERCASE' => __('LOWERCASE','nutrition-diet'),
        ),
	) );
	$wp_customize->add_setting( 'nutrition_diet_section_scroll_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_scroll_heading', array(
		'label'       => esc_html__( 'Scroll Top Settings', 'nutrition-diet' ),
		'section'     => 'nutrition_diet_theme_settings',
		'settings'    => 'nutrition_diet_section_scroll_heading',
	) ) );
	$wp_customize->add_setting(
		'nutrition_diet_scroll_enable',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_scroll_enable',
			array(
				'settings'        => 'nutrition_diet_scroll_enable',
				'section'         => 'nutrition_diet_theme_settings',
				'label'           => __( 'show Scroll Top', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'nutrition_diet_scroll_options',
		array(
			'default' => 'right_align',
			'transport' => 'refresh',
			'sanitize_callback' => 'nutrition_diet_sanitize_choices'
		)
	);
	$wp_customize->add_control( new Nutrition_Diet_Text_Radio_Button_Custom_Control( $wp_customize, 'nutrition_diet_scroll_options',
		array(
			'type' => 'select',
			'label' => esc_html__( 'Scroll Top Alignment', 'nutrition-diet' ),
			'section' => 'nutrition_diet_theme_settings',
			'choices' => array(
				'left_align' => __('LEFT','nutrition-diet'),
				'center_align' => __('CENTER','nutrition-diet'),
				'right_align' => __('RIGHT','nutrition-diet'),
			)
		)
	) );
	$wp_customize->add_setting('nutrition_diet_scroll_top_icon',array(
		'default'	=> 'fas fa-chevron-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Nutrition_Diet_Fontawesome_Icon_Chooser(
        $wp_customize,'nutrition_diet_scroll_top_icon',array(
		'label'	=> __('Add Scroll Top Icon','nutrition-diet'),
		'transport' => 'refresh',
		'section'	=> 'nutrition_diet_theme_settings',
		'setting'	=> 'nutrition_diet_scroll_top_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'nutrition_diet_section_cursor_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_cursor_heading', array(
		'label'       => esc_html__( 'Cursor Setting', 'nutrition-diet' ),
		'section'     => 'nutrition_diet_theme_settings',
		'settings'    => 'nutrition_diet_section_cursor_heading',
	) ) );

	$wp_customize->add_setting(
		'nutrition_diet_enable_custom_cursor',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_enable_custom_cursor',
			array(
				'settings'        => 'nutrition_diet_enable_custom_cursor',
				'section'         => 'nutrition_diet_theme_settings',
				'label'           => __( 'show custom cursor', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);

	$wp_customize->add_setting( 'nutrition_diet_section_animation_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_animation_heading', array(
		'label'       => esc_html__( 'Animation Setting', 'nutrition-diet' ),
		'section'     => 'nutrition_diet_theme_settings',
		'settings'    => 'nutrition_diet_section_animation_heading',
	) ) );

	$wp_customize->add_setting(
		'nutrition_diet_animation_enable',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_animation_enable',
			array(
				'settings'        => 'nutrition_diet_animation_enable',
				'section'         => 'nutrition_diet_theme_settings',
				'label'           => __( 'show/Hide Animation', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	
	// Post Layouts
	$wp_customize->add_panel( 'nutrition_diet_post_panel', array(
		'title' => esc_html__( 'Post Layout', 'nutrition-diet' ),
		'priority' => 4,
	));
    $wp_customize->add_section('nutrition_diet_layout',array(
        'title' => __('Single-Post Layout', 'nutrition-diet'),
        'panel' => 'nutrition_diet_post_panel',
    ) );
    $wp_customize->add_setting( 'nutrition_diet_section_post_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_post_heading', array(
		'label'       => esc_html__( 'Single Post Structure', 'nutrition-diet' ),
		'section'     => 'nutrition_diet_layout',
		'settings'    => 'nutrition_diet_section_post_heading',
	) ) );
	$wp_customize->add_setting( 'nutrition_diet_single_post_option',
		array(
			'default' => 'single_right_sidebar',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Nutrition_Diet_Radio_Image_Control( $wp_customize, 'nutrition_diet_single_post_option',
		array(
			'type'=>'select',
			'label' => __( 'select Single Post Page Layout', 'nutrition-diet' ),
			'section' => 'nutrition_diet_layout',
			'choices' => array(

				'single_right_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/2column.jpg',
					'name' => __( 'Right Sidebar', 'nutrition-diet' )
				),
				'single_left_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/left.png',
					'name' => __( 'Left Sidebar', 'nutrition-diet' )
				),
				'single_full_width' => array(
					'image' => get_template_directory_uri().'/assets/images/1column.jpg',
					'name' => __( 'One Column', 'nutrition-diet' )
				),
			)
		)
	) );
	$wp_customize->add_setting('nutrition_diet_single_post_date',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_single_post_date',
			array(
				'settings'        => 'nutrition_diet_single_post_date',
				'section'         => 'nutrition_diet_layout',
				'label'           => __( 'Show Date', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'nutrition_diet_single_post_date', array(
		'selector' => '.date-box',
		'render_callback' => 'nutrition_diet_customize_partial_nutrition_diet_single_post_date',
	) );
	$wp_customize->add_setting('nutrition_diet_single_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Nutrition_Diet_Fontawesome_Icon_Chooser(
        $wp_customize,'nutrition_diet_single_date_icon',array(
		'label'	=> __('date Icon','nutrition-diet'),
		'transport' => 'refresh',
		'section'	=> 'nutrition_diet_layout',
		'setting'	=> 'nutrition_diet_single_date_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('nutrition_diet_single_post_admin',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_single_post_admin',
			array(
				'settings'        => 'nutrition_diet_single_post_admin',
				'section'         => 'nutrition_diet_layout',
				'label'           => __( 'Show Author/Admin', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'nutrition_diet_single_post_admin', array(
		'selector' => '.entry-author',
		'render_callback' => 'nutrition_diet_customize_partial_nutrition_diet_single_post_admin',
	) );
	$wp_customize->add_setting('nutrition_diet_single_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Nutrition_Diet_Fontawesome_Icon_Chooser(
        $wp_customize,'nutrition_diet_single_author_icon',array(
		'label'	=> __('Author Icon','nutrition-diet'),
		'transport' => 'refresh',
		'section'	=> 'nutrition_diet_layout',
		'setting'	=> 'nutrition_diet_single_author_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('nutrition_diet_single_post_comment',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_single_post_comment',
			array(
				'settings'        => 'nutrition_diet_single_post_comment',
				'section'         => 'nutrition_diet_layout',
				'label'           => __( 'Show Comment', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('nutrition_diet_single_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Nutrition_Diet_Fontawesome_Icon_Chooser(
        $wp_customize,'nutrition_diet_single_comment_icon',array(
		'label'	=> __('comment Icon','nutrition-diet'),
		'transport' => 'refresh',
		'section'	=> 'nutrition_diet_layout',
		'setting'	=> 'nutrition_diet_single_comment_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('nutrition_diet_single_post_tag_count',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_single_post_tag_count',
			array(
				'settings'        => 'nutrition_diet_single_post_tag_count',
				'section'         => 'nutrition_diet_layout',
				'label'           => __( 'Show tag count', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('nutrition_diet_single_tag_icon',array(
		'default'	=> 'fas fa-tags',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Nutrition_Diet_Fontawesome_Icon_Chooser(
        $wp_customize,'nutrition_diet_single_tag_icon',array(
		'label'	=> __('tag Icon','nutrition-diet'),
		'transport' => 'refresh',
		'section'	=> 'nutrition_diet_layout',
		'setting'	=> 'nutrition_diet_single_tag_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('nutrition_diet_single_post_tag',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_single_post_tag',
			array(
				'settings'        => 'nutrition_diet_single_post_tag',
				'section'         => 'nutrition_diet_layout',
				'label'           => __( 'Show Tags', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'nutrition_diet_single_post_tag', array(
		'selector' => '.single-tags',
		'render_callback' => 'nutrition_diet_customize_partial_nutrition_diet_single_post_tag',
	) );
	$wp_customize->add_setting('nutrition_diet_similar_post',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_similar_post',
			array(
				'settings'        => 'nutrition_diet_similar_post',
				'section'         => 'nutrition_diet_layout',
				'label'           => __( 'Show Similar post', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('nutrition_diet_similar_text',array(
		'default' => 'Explore More',
		'sanitize_callback' => 'sanitize_text_field'
	)); 
	$wp_customize->add_control('nutrition_diet_similar_text',array(
		'label' => esc_html__('Similar Post Heading','nutrition-diet'),
		'section' => 'nutrition_diet_layout',
		'setting' => 'nutrition_diet_similar_text',
		'type'    => 'text'
	));
	$wp_customize->add_section('nutrition_diet_archieve_post_layot',array(
        'title' => __('Archieve-Post Layout', 'nutrition-diet'),
        'panel' => 'nutrition_diet_post_panel',
    ) );
	$wp_customize->add_setting( 'nutrition_diet_section_archive_post_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_archive_post_heading', array(
		'label'       => esc_html__( 'Archieve Post Structure', 'nutrition-diet' ),
		'section'     => 'nutrition_diet_archieve_post_layot',
		'settings'    => 'nutrition_diet_section_archive_post_heading',
	) ) );
    $wp_customize->add_setting( 'nutrition_diet_post_option',
		array(
			'default' => 'right_sidebar',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Nutrition_Diet_Radio_Image_Control( $wp_customize, 'nutrition_diet_post_option',
		array(
			'type'=>'select',
			'label' => __( 'select Post Page Layout', 'nutrition-diet' ),
			'section' => 'nutrition_diet_archieve_post_layot',
			'choices' => array(
				'right_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/2column.jpg',
					'name' => __( 'Right Sidebar', 'nutrition-diet' )
				),
				'left_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/left.png',
					'name' => __( 'Left Sidebar', 'nutrition-diet' )
				),
				'one_column' => array(
					'image' => get_template_directory_uri().'/assets/images/1column.jpg',
					'name' => __( 'One Column', 'nutrition-diet' )
				),
				'three_column' => array(
					'image' => get_template_directory_uri().'/assets/images/3column.jpg',
					'name' => __( 'Three Column', 'nutrition-diet' )
				),
				'four_column' => array(
					'image' => get_template_directory_uri().'/assets/images/4column.jpg',
					'name' => __( 'Four Column', 'nutrition-diet' )
				),
				'grid_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/grid-sidebar.jpg',
					'name' => __( 'Grid-Right-Sidebar Layout', 'nutrition-diet' )
				),
				'grid_left_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/grid-left.png',
					'name' => __( 'Grid-Left-Sidebar Layout', 'nutrition-diet' )
				),
				'grid_post' => array(
					'image' => get_template_directory_uri().'/assets/images/grid.jpg',
					'name' => __( 'Grid Layout', 'nutrition-diet' )
				)
			)
		)
	) );
	$wp_customize->add_setting( 'nutrition_diet_grid_column',
		array(
			'default' => '3_column',
			'transport' => 'refresh',
			'sanitize_callback' => 'nutrition_diet_sanitize_choices'
		)
	);
	$wp_customize->add_control( new Nutrition_Diet_Text_Radio_Button_Custom_Control( $wp_customize, 'nutrition_diet_grid_column',
		array(
			'type' => 'select',
			'label' => esc_html__('Grid Post Per Row','nutrition-diet'),
			'section' => 'nutrition_diet_archieve_post_layot',
			'choices' => array(
				'1_column' => __('1','nutrition-diet'),
	            '2_column' => __('2','nutrition-diet'),
	            '3_column' => __('3','nutrition-diet'),
	            '4_column' => __('4','nutrition-diet'),
			)
		)
	) );
	$wp_customize->add_setting('archieve_post_order', array(
        'default' => array('title', 'image', 'meta','excerpt','btn'),
        'sanitize_callback' => 'nutrition_diet_sanitize_sortable',
    ));
    $wp_customize->add_control(new Nutrition_Diet_Control_Sortable($wp_customize, 'archieve_post_order', array(
    	'label' => esc_html__('Post Order', 'nutrition-diet'),
        'description' => __('Drag & Drop post items to re-arrange the order and also hide and show items as per the need by clicking on the eye icon.', 'nutrition-diet') ,
        'section' => 'nutrition_diet_archieve_post_layot',
        'choices' => array(
            'title' => __('title', 'nutrition-diet') ,
            'image' => __('media', 'nutrition-diet') ,
            'meta' => __('meta', 'nutrition-diet') ,
            'excerpt' => __('excerpt', 'nutrition-diet') ,
            'btn' => __('Read more', 'nutrition-diet') ,
        ) ,
    )));
	$wp_customize->add_setting('nutrition_diet_post_excerpt',array(
		'default'=> 30,
		'transport' => 'refresh',
		'sanitize_callback' => 'nutrition_diet_sanitize_integer'
	));
	$wp_customize->add_control(new Nutrition_Diet_Slider_Custom_Control( $wp_customize, 'nutrition_diet_post_excerpt',array(
		'label' => esc_html__( 'Excerpt Limit','nutrition-diet' ),
		'section'=> 'nutrition_diet_archieve_post_layot',
		'settings'=>'nutrition_diet_post_excerpt',
		'input_attrs' => array(
			'reset'			   => 30,
            'step'             => 1,
			'min'              => 0,
			'max'              => 100,
        ),
	)));
	$wp_customize->add_setting('nutrition_diet_read_more_text',array(
		'default' => 'Read More',
		'sanitize_callback' => 'sanitize_text_field'
	)); 
	$wp_customize->add_control('nutrition_diet_read_more_text',array(
		'label' => esc_html__('Read More Text','nutrition-diet'),
		'section' => 'nutrition_diet_archieve_post_layot',
		'setting' => 'nutrition_diet_read_more_text',
		'type'    => 'text'
	));
	$wp_customize->add_setting('nutrition_diet_read_more_icon',array(
		'default'	=> 'fas fa-arrow-right',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Nutrition_Diet_Fontawesome_Icon_Chooser(
        $wp_customize,'nutrition_diet_read_more_icon',array(
		'label'	=> __('Read More Icon','nutrition-diet'),
		'transport' => 'refresh',
		'section'	=> 'nutrition_diet_archieve_post_layot',
		'setting'	=> 'nutrition_diet_read_more_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('nutrition_diet_date',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_date',
			array(
				'settings'        => 'nutrition_diet_date',
				'section'         => 'nutrition_diet_archieve_post_layot',
				'label'           => __( 'Show Date', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'nutrition_diet_date', array(
		'selector' => '.date-box',
		'render_callback' => 'nutrition_diet_customize_partial_nutrition_diet_date',
	) );
	$wp_customize->add_setting('nutrition_diet_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Nutrition_Diet_Fontawesome_Icon_Chooser(
        $wp_customize,'nutrition_diet_date_icon',array(
		'label'	=> __('date Icon','nutrition-diet'),
		'transport' => 'refresh',
		'section'	=> 'nutrition_diet_archieve_post_layot',
		'setting'	=> 'nutrition_diet_date_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('nutrition_diet_admin',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_admin',
			array(
				'settings'        => 'nutrition_diet_admin',
				'section'         => 'nutrition_diet_archieve_post_layot',
				'label'           => __( 'Show Author/Admin', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'nutrition_diet_admin', array(
		'selector' => '.entry-author',
		'render_callback' => 'nutrition_diet_customize_partial_nutrition_diet_admin',
	) );
	$wp_customize->add_setting('nutrition_diet_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Nutrition_Diet_Fontawesome_Icon_Chooser(
        $wp_customize,'nutrition_diet_author_icon',array(
		'label'	=> __('Author Icon','nutrition-diet'),
		'transport' => 'refresh',
		'section'	=> 'nutrition_diet_archieve_post_layot',
		'setting'	=> 'nutrition_diet_author_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('nutrition_diet_comment',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_comment',
			array(
				'settings'        => 'nutrition_diet_comment',
				'section'         => 'nutrition_diet_archieve_post_layot',
				'label'           => __( 'Show Comment', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'nutrition_diet_comment', array(
		'selector' => '.entry-comments',
		'render_callback' => 'nutrition_diet_customize_partial_nutrition_diet_comment',
	) );
	$wp_customize->add_setting('nutrition_diet_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Nutrition_Diet_Fontawesome_Icon_Chooser(
        $wp_customize,'nutrition_diet_comment_icon',array(
		'label'	=> __('comment Icon','nutrition-diet'),
		'transport' => 'refresh',
		'section'	=> 'nutrition_diet_archieve_post_layot',
		'setting'	=> 'nutrition_diet_comment_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('nutrition_diet_tag',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_tag',
			array(
				'settings'        => 'nutrition_diet_tag',
				'section'         => 'nutrition_diet_archieve_post_layot',
				'label'           => __( 'Show tag count', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'nutrition_diet_tag', array(
		'selector' => '.tags',
		'render_callback' => 'nutrition_diet_customize_partial_nutrition_diet_tag',
	) );
	$wp_customize->add_setting('nutrition_diet_tag_icon',array(
		'default'	=> 'fas fa-tags',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Nutrition_Diet_Fontawesome_Icon_Chooser(
        $wp_customize,'nutrition_diet_tag_icon',array(
		'label'	=> __('tag Icon','nutrition-diet'),
		'transport' => 'refresh',
		'section'	=> 'nutrition_diet_archieve_post_layot',
		'setting'	=> 'nutrition_diet_tag_icon',
		'type'		=> 'icon'
	)));

	// header-image
	$wp_customize->add_setting( 'nutrition_diet_section_header_image_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_header_image_heading', array(
		'label'       => esc_html__( 'Header Image Settings', 'nutrition-diet' ),
		'section'     => 'header_image',
		'settings'    => 'nutrition_diet_section_header_image_heading',
		'priority'    =>'1',
	) ) );

	$wp_customize->add_setting('nutrition_diet_show_header_image',array(
        'default' => 'on',
        'sanitize_callback' => 'nutrition_diet_sanitize_choices'
	));
	$wp_customize->add_control('nutrition_diet_show_header_image',array(
        'type' => 'select',
        'label' => __('Select Option','nutrition-diet'),
        'section' => 'header_image',
        'choices' => array(
            'on' => __('With Header Image','nutrition-diet'),
            'off' => __('Without Header Image','nutrition-diet'),
        ),
	) );
  
	// breadcrumb
	$wp_customize->add_section('nutrition_diet_breadcrumb_settings',array(
        'title' => __('Breadcrumb Settings', 'nutrition-diet'),
        'priority' => 4
    ) );
	$wp_customize->add_setting( 'nutrition_diet_section_breadcrumb_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_breadcrumb_heading', array(
		'label'       => esc_html__( 'theme Breadcrumb Settings', 'nutrition-diet' ),
		'section'     => 'nutrition_diet_breadcrumb_settings',
		'settings'    => 'nutrition_diet_section_breadcrumb_heading',
	) ) );
	$wp_customize->add_setting(
		'nutrition_diet_enable_breadcrumb',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_enable_breadcrumb',
			array(
				'settings'        => 'nutrition_diet_enable_breadcrumb',
				'section'         => 'nutrition_diet_breadcrumb_settings',
				'label'           => __( 'Show Breadcrumb', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('nutrition_diet_breadcrumb_separator', array(
        'default' => ' / ',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('nutrition_diet_breadcrumb_separator', array(
        'label' => __('Breadcrumb Separator', 'nutrition-diet'),
        'section' => 'nutrition_diet_breadcrumb_settings',
        'type' => 'text',
    ));
	$wp_customize->add_setting( 'nutrition_diet_single_breadcrumb_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_single_breadcrumb_heading', array(
		'label'       => esc_html__( 'Single post & Page', 'nutrition-diet' ),
		'section'     => 'nutrition_diet_breadcrumb_settings',
		'settings'    => 'nutrition_diet_single_breadcrumb_heading',
	) ) );
	$wp_customize->add_setting(
		'nutrition_diet_single_enable_breadcrumb',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_single_enable_breadcrumb',
			array(
				'settings'        => 'nutrition_diet_single_enable_breadcrumb',
				'section'         => 'nutrition_diet_breadcrumb_settings',
				'label'           => __( 'Show Breadcrumb', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	if ( class_exists( 'WooCommerce' ) ) { 
		$wp_customize->add_setting( 'nutrition_diet_woocommerce_breadcrumb_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_woocommerce_breadcrumb_heading', array(
			'label'       => esc_html__( 'Woocommerce Breadcrumb', 'nutrition-diet' ),
			'section'     => 'nutrition_diet_breadcrumb_settings',
			'settings'    => 'nutrition_diet_woocommerce_breadcrumb_heading',
		) ) );
		$wp_customize->add_setting(
			'nutrition_diet_woocommerce_enable_breadcrumb',
			array(
				'type'                 => 'option',
				'capability'           => 'edit_theme_options',
				'theme_supports'       => '',
				'default'              => '1',
				'transport'            => 'refresh',
				'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
			)
		);
		$wp_customize->add_control(
			new Nutrition_Diet_Customizer_Customcontrol_Switch(
				$wp_customize,
				'nutrition_diet_woocommerce_enable_breadcrumb',
				array(
					'settings'        => 'nutrition_diet_woocommerce_enable_breadcrumb',
					'section'         => 'nutrition_diet_breadcrumb_settings',
					'label'           => __( 'Show Breadcrumb', 'nutrition-diet' ),				
					'choices'		  => array(
						'1'      => __( 'On', 'nutrition-diet' ),
						'off'    => __( 'Off', 'nutrition-diet' ),
					),
					'active_callback' => '',
				)
			)
		);
		$wp_customize->add_setting('woocommerce_breadcrumb_separator', array(
	        'default' => ' / ',
	        'sanitize_callback' => 'sanitize_text_field',
	    ));
	    $wp_customize->add_control('woocommerce_breadcrumb_separator', array(
	        'label' => __('Breadcrumb Separator', 'nutrition-diet'),
	        'section' => 'nutrition_diet_breadcrumb_settings',
	        'type' => 'text',
	    ));
	}

	// woocommerce
	if ( class_exists( 'WooCommerce' ) ) { 
		$wp_customize->add_section('nutrition_diet_woocommerce_settings',array(
		    'title' => __('WooCommerce Settings', 'nutrition-diet'),
		    'priority'   => 4,
		) );
		$wp_customize->add_setting( 'nutrition_diet_section_shoppage_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_shoppage_heading', array(
			'label'       => esc_html__( 'Sidebar Settings', 'nutrition-diet' ),
			'section'     => 'nutrition_diet_woocommerce_settings',
			'settings'    => 'nutrition_diet_section_shoppage_heading',
		) ) );
		$wp_customize->add_setting( 'nutrition_diet_shop_page_sidebar',
			array(
				'default' => 'right_sidebar',
				'transport' => 'refresh',
				'sanitize_callback' => 'sanitize_text_field'
			)
		);
		$wp_customize->add_control( new Nutrition_Diet_Radio_Image_Control( $wp_customize, 'nutrition_diet_shop_page_sidebar',
			array(
				'type'=>'select',
				'label' => __( 'Show Shop Page Sidebar', 'nutrition-diet' ),
				'section'     => 'nutrition_diet_woocommerce_settings',
				'choices' => array(

					'right_sidebar' => array(
						'image' => get_template_directory_uri().'/assets/images/2column.jpg',
						'name' => __( 'Right Sidebar', 'nutrition-diet' )
					),
					'left_sidebar' => array(
						'image' => get_template_directory_uri().'/assets/images/left.png',
						'name' => __( 'Left Sidebar', 'nutrition-diet' )
					),
					'full_width' => array(
						'image' => get_template_directory_uri().'/assets/images/1column.jpg',
						'name' => __( 'Full Width', 'nutrition-diet' )
					),
				)
			)
		) );
		$wp_customize->add_setting( 'nutrition_diet_wocommerce_single_page_sidebar',
			array(
				'default' => 'right_sidebar',
				'transport' => 'refresh',
				'sanitize_callback' => 'sanitize_text_field'
			)
		);
		$wp_customize->add_control( new Nutrition_Diet_Radio_Image_Control( $wp_customize, 'nutrition_diet_wocommerce_single_page_sidebar',
			array(
				'type'=>'select',
				'label'           => __( 'Show Single Product Page Sidebar', 'nutrition-diet' ),
				'section'     => 'nutrition_diet_woocommerce_settings',
				'choices' => array(

					'right_sidebar' => array(
						'image' => get_template_directory_uri().'/assets/images/2column.jpg',
						'name' => __( 'Right Sidebar', 'nutrition-diet' )
					),
					'left_sidebar' => array(
						'image' => get_template_directory_uri().'/assets/images/left.png',
						'name' => __( 'Left Sidebar', 'nutrition-diet' )
					),
					'full_width' => array(
						'image' => get_template_directory_uri().'/assets/images/1column.jpg',
						'name' => __( 'Full Width', 'nutrition-diet' )
					),
				)
			)
		) );
		$wp_customize->add_setting( 'nutrition_diet_section_archieve_product_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_archieve_product_heading', array(
			'label'       => esc_html__( 'Archieve Product Settings', 'nutrition-diet' ),
			'section'     => 'nutrition_diet_woocommerce_settings',
			'settings'    => 'nutrition_diet_section_archieve_product_heading',
		) ) );

		$wp_customize->add_setting('nutrition_diet_archieve_item_columns',array(
		    'default' => '3',
		    'sanitize_callback' => 'nutrition_diet_sanitize_choices'
		));

		$wp_customize->add_control('nutrition_diet_archieve_item_columns',array(
		    'type' => 'select',
		    'label' => __('Select No of Columns','nutrition-diet'),
		    'section' => 'nutrition_diet_woocommerce_settings',
		    'choices' => array(
		        '1' => __('One Column','nutrition-diet'),
		        '2' => __('Two Column','nutrition-diet'),
		        '3' => __('Three Column','nutrition-diet'),
		        '4' => __('four Column','nutrition-diet'),
		        '5' => __('Five Column','nutrition-diet'),
		        '6' => __('Six Column','nutrition-diet'),
		    ),
		) );

		$wp_customize->add_setting( 'nutrition_diet_archieve_shop_perpage', array(
			'default'              => 6,
			'type'                 => 'theme_mod',
			'transport' 		   => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_sanitize_number_absint',
			'sanitize_js_callback' => 'absint',
		) );

		$wp_customize->add_control( 'nutrition_diet_archieve_shop_perpage', array(
			'label'       => esc_html__( 'Display Products','nutrition-diet' ),
			'section'     => 'nutrition_diet_woocommerce_settings',
			'type'        => 'number',
			'input_attrs' => array(
				'step'             => 1,
				'min'              => 0,
				'max'              => 30,
			),
		) );

		$wp_customize->add_setting( 'nutrition_diet_section_related_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_related_heading', array(
			'label'       => esc_html__( 'Related Product Settings', 'nutrition-diet' ),
			'section'     => 'nutrition_diet_woocommerce_settings',
			'settings'    => 'nutrition_diet_section_related_heading',
		) ) );
		$wp_customize->add_setting('woocommerce_related_products_heading', array(
	        'default' => 'Related products',
	        'sanitize_callback' => 'sanitize_text_field',
	    ));
	    $wp_customize->add_control('woocommerce_related_products_heading', array(
	        'label' => __('Related Products Heading', 'nutrition-diet'),
	        'section' => 'nutrition_diet_woocommerce_settings',
	        'type' => 'text',
	    ));
		$wp_customize->add_setting('nutrition_diet_related_item_columns',array(
		    'default' => '3',
		    'sanitize_callback' => 'nutrition_diet_sanitize_choices'
		));
		$wp_customize->add_control('nutrition_diet_related_item_columns',array(
		    'type' => 'select',
		    'label' => __('Select No of Columns','nutrition-diet'),
		    'section' => 'nutrition_diet_woocommerce_settings',
		    'choices' => array(
		        '1' => __('One Column','nutrition-diet'),
		        '2' => __('Two Column','nutrition-diet'),
		        '3' => __('Three Column','nutrition-diet'),
		        '4' => __('four Column','nutrition-diet'),
		        '5' => __('Five Column','nutrition-diet'),
		        '6' => __('Six Column','nutrition-diet'),
		    ),
		) );
		$wp_customize->add_setting( 'nutrition_diet_related_shop_perpage', array(
			'default'              => 3,
			'type'                 => 'theme_mod',
			'transport' 		   => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_sanitize_number_absint',
			'sanitize_js_callback' => 'absint',
		) );
		$wp_customize->add_control( 'nutrition_diet_related_shop_perpage', array(
			'label'       => esc_html__( 'Display Products','nutrition-diet' ),
			'section'     => 'nutrition_diet_woocommerce_settings',
			'type'        => 'number',
			'input_attrs' => array(
				'step'             => 1,
				'min'              => 0,
				'max'              => 10,
			),
		) );
		$wp_customize->add_setting(
			'nutrition_diet_related_product',
			array(
				'type'                 => 'option',
				'capability'           => 'edit_theme_options',
				'theme_supports'       => '',
				'default'              => '1',
				'transport'            => 'refresh',
				'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
			)
		);
		$wp_customize->add_control(new Nutrition_Diet_Customizer_Customcontrol_Switch($wp_customize,'nutrition_diet_related_product',
			array(
				'settings'        => 'nutrition_diet_related_product',
				'section'         => 'nutrition_diet_woocommerce_settings',
				'label'           => __( 'Show Related Products', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		));
	}
	// mobile width
	$wp_customize->add_section('nutrition_diet_mobile_options',array(
        'title' => __('Mobile Media settings', 'nutrition-diet'),
        'priority' => 4,
    ) );
    $wp_customize->add_setting( 'nutrition_diet_section_mobile_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_mobile_heading', array(
		'label'       => esc_html__( 'Mobile Media settings', 'nutrition-diet' ),
		'section'     => 'nutrition_diet_mobile_options',
		'settings'    => 'nutrition_diet_section_mobile_heading',
	) ) );
	$wp_customize->add_setting(
		'nutrition_diet_slider_button_mobile_show_hide',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_slider_button_mobile_show_hide',
			array(
				'settings'        => 'nutrition_diet_slider_button_mobile_show_hide',
				'section'         => 'nutrition_diet_mobile_options',
				'label'           => __( 'Show Slider Button', 'nutrition-diet' ),
				'description' => __('Control wont function if the button is off in the main slider settings.', 'nutrition-diet') ,				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting(
		'nutrition_diet_scroll_enable_mobile',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_scroll_enable_mobile',
			array(
				'settings'        => 'nutrition_diet_scroll_enable_mobile',
				'section'         => 'nutrition_diet_mobile_options',
				'label'           => __( 'Show Scroll Top', 'nutrition-diet' ),	
				'description' => __('Control wont function if scroll-top is off in the main settings.', 'nutrition-diet') ,			
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'nutrition_diet_section_mobile_breadcrumb_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Nutrition_Diet_Customizer_Customcontrol_Section_Heading( $wp_customize, 'nutrition_diet_section_mobile_breadcrumb_heading', array(
		'label'       => esc_html__( 'Mobile Breadcrumb settings', 'nutrition-diet' ),
		'description' => __('Controls wont function if the breadcrumb is off in the main breadcrumb settings.', 'nutrition-diet') ,
		'section'     => 'nutrition_diet_mobile_options',
		'settings'    => 'nutrition_diet_section_mobile_breadcrumb_heading',
	) ) );
	$wp_customize->add_setting(
		'nutrition_diet_enable_breadcrumb_mobile',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_enable_breadcrumb_mobile',
			array(
				'settings'        => 'nutrition_diet_enable_breadcrumb_mobile',
				'section'         => 'nutrition_diet_mobile_options',
				'label'           => __( 'Theme Breadcrumb', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting(
		'nutrition_diet_single_enable_breadcrumb_mobile',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Nutrition_Diet_Customizer_Customcontrol_Switch(
			$wp_customize,
			'nutrition_diet_single_enable_breadcrumb_mobile',
			array(
				'settings'        => 'nutrition_diet_single_enable_breadcrumb_mobile',
				'section'         => 'nutrition_diet_mobile_options',
				'label'           => __( 'Single Post & Page', 'nutrition-diet' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'nutrition-diet' ),
					'off'    => __( 'Off', 'nutrition-diet' ),
				),
				'active_callback' => '',
			)
		)
	);
	if ( class_exists( 'WooCommerce' ) ) {
		$wp_customize->add_setting(
			'nutrition_diet_woocommerce_enable_breadcrumb_mobile',
			array(
				'type'                 => 'option',
				'capability'           => 'edit_theme_options',
				'theme_supports'       => '',
				'default'              => '1',
				'transport'            => 'refresh',
				'sanitize_callback'    => 'nutrition_diet_callback_sanitize_switch',
			)
		);
		$wp_customize->add_control(
			new Nutrition_Diet_Customizer_Customcontrol_Switch(
				$wp_customize,
				'nutrition_diet_woocommerce_enable_breadcrumb_mobile',
				array(
					'settings'        => 'nutrition_diet_woocommerce_enable_breadcrumb_mobile',
					'section'         => 'nutrition_diet_mobile_options',
					'label'           => __( 'wooCommerce Breadcrumb', 'nutrition-diet' ),				
					'choices'		  => array(
						'1'      => __( 'On', 'nutrition-diet' ),
						'off'    => __( 'Off', 'nutrition-diet' ),
					),
					'active_callback' => '',
				)
			)
		);
	}

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'nutrition_diet_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'nutrition_diet_customize_partial_blogdescription',
	) );

	//front page
	$num_sections = apply_filters( 'nutrition_diet_front_page_sections', 4 );

	// Create a setting and control for each of the sections available in the theme.
	for ( $i = 1; $i < ( 1 + $num_sections ); $i++ ) {
		$wp_customize->add_setting( 'panel_' . $i, array(
			'default'           => false,
			'sanitize_callback' => 'nutrition_diet_sanitize_dropdown_pages',
			'transport'         => 'postMessage',
		) );

		$wp_customize->add_control( 'panel_' . $i, array(
			/* translators: %d is the front page section number */
			'label'          => sprintf( __( 'Front Page Section %d Content', 'nutrition-diet' ), $i ),
			'description'    => ( 1 !== $i ? '' : __( 'Select pages to feature in each area from the dropdowns. Add an image to a section by setting a featured image in the page editor. Empty sections will not be displayed.', 'nutrition-diet' ) ),
			'section'        => 'theme_options',
			'type'           => 'dropdown-pages',
			'allow_addition' => true,
			'active_callback' => 'nutrition_diet_is_static_front_page',
		) );

		$wp_customize->selective_refresh->add_partial( 'panel_' . $i, array(
			'selector'            => '#panel' . $i,
			'render_callback'     => 'nutrition_diet_front_page_section',
			'container_inclusive' => true,
		) );
	}
}
add_action( 'customize_register', 'nutrition_diet_customize_register' );

function nutrition_diet_customize_partial_blogname() {
	bloginfo( 'name' );
}
function nutrition_diet_customize_partial_blogdescription() {
	bloginfo( 'description' );
}
function nutrition_diet_is_static_front_page() {
	return ( is_front_page() && ! is_home() );
}
function nutrition_diet_is_view_with_layout_option() {
	return ( is_page() || ( is_archive() && ! is_active_sidebar( 'sidebar-1' ) ) );
}

define('NUTRITION_DIET_PRO_LINK',__('https://www.ovationthemes.com/wordpress/nutrition-diet-wordpress-theme/','nutrition-diet'));

/* Pro control */
if (class_exists('WP_Customize_Control') && !class_exists('Nutrition_Diet_Pro_Control')):
    class Nutrition_Diet_Pro_Control extends WP_Customize_Control{

    public function render_content(){?>
        <label style="overflow: hidden; zoom: 1;">
	        <div class="col-md upsell-btn">
                <a href="<?php echo esc_url( NUTRITION_DIET_PRO_LINK ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('UPGRADE NUTRITION DIET PREMIUM','nutrition-diet');?> </a>
	        </div>
            <div class="col-md">
                <img class="nutrition_diet_img_responsive " src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png">
            </div>
	        <div class="col-md">
	            <h3 style="margin-top:10px; margin-left: 20px; text-decoration:underline; color:#333;"><?php esc_html_e('NUTRITION DIET PREMIUM - Features', 'nutrition-diet'); ?></h3>
                <ul style="padding-top:10px">
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Responsive Design', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Boxed or fullwidth layout', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Shortcode Support', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Demo Importer', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Section Reordering', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Contact Page Template', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Multiple Blog Layouts', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Unlimited Color Options', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Designed with HTML5 and CSS3', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Customizable Design & Code', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Cross Browser Support', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Detailed Documentation Included', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Stylish Custom Widgets', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Patterns Background', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('WPML Compatible (Translation Ready)', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Woo-commerce Compatible', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Full Support', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('10+ Sections', 'nutrition-diet');?> </li>
                    <li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Live Customizer', 'nutrition-diet');?> </li>
                   	<li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('AMP Ready', 'nutrition-diet');?> </li>
                   	<li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Clean Code', 'nutrition-diet');?> </li>
                   	<li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('SEO Friendly', 'nutrition-diet');?> </li>
                   	<li class="upsell-nutrition_diet"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Supper Fast', 'nutrition-diet');?> </li>
                </ul>
        	</div>
		    <div class="col-md upsell-btn upsell-btn-bottom">
	            <a href="<?php echo esc_url( NUTRITION_DIET_PRO_LINK ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('UPGRADE NUTRITION DIET PREMIUM','nutrition-diet');?> </a>
		    </div>
        </label>
    <?php } }
endif;
