<?php
/**
 * Wizard
 *
 * @package Skin_Care_Solutions_Whizzie
 * @author Catapult Themes
 * @since 1.0.0
 */

class Skin_Care_Solutions_Whizzie {
	
	protected $version = '1.1.0';
	
	/** @var string Current theme name, used as namespace in actions. */
	protected $skin_care_solutions_theme_name = '';
	protected $skin_care_solutions_theme_title = '';
	
	/** @var string Wizard page slug and title. */
	protected $skin_care_solutions_page_slug = '';
	protected $skin_care_solutions_page_title = '';
	
	/** @var array Wizard steps set by user. */
	protected $config_steps = array();
	
	/**
	 * Relative plugin url for this plugin folder
	 * @since 1.0.0
	 * @var string
	 */
	protected $skin_care_solutions_plugin_url = '';

	public $skin_care_solutions_plugin_path;
	public $parent_slug;
	
	/**
	 * TGMPA instance storage
	 *
	 * @var object
	 */
	protected $tgmpa_instance;
	
	/**
	 * TGMPA Menu slug
	 *
	 * @var string
	 */
	protected $tgmpa_menu_slug = 'tgmpa-install-plugins';
	
	/**
	 * TGMPA Menu url
	 *
	 * @var string
	 */
	protected $tgmpa_url = 'themes.php?page=tgmpa-install-plugins';
	
	/**
	 * Constructor
	 *
	 * @param $config	Our config parameters
	 */
	public function __construct( $config ) {
		$this->set_vars( $config );
		$this->init();
	}
	
	/**
	 * Set some settings
	 * @since 1.0.0
	 * @param $config	Our config parameters
	 */
	public function set_vars( $config ) {
	
		require_once trailingslashit( WHIZZIE_DIR ) . 'tgm/class-tgm-plugin-activation.php';
		require_once trailingslashit( WHIZZIE_DIR ) . 'tgm/tgm.php';

		if( isset( $config['skin_care_solutions_page_slug'] ) ) {
			$this->skin_care_solutions_page_slug = esc_attr( $config['skin_care_solutions_page_slug'] );
		}
		if( isset( $config['skin_care_solutions_page_title'] ) ) {
			$this->skin_care_solutions_page_title = esc_attr( $config['skin_care_solutions_page_title'] );
		}
		if( isset( $config['steps'] ) ) {
			$this->config_steps = $config['steps'];
		}
		
		$this->skin_care_solutions_plugin_path = trailingslashit( dirname( __FILE__ ) );
		$relative_url = str_replace( get_template_directory(), '', $this->skin_care_solutions_plugin_path );
		$this->skin_care_solutions_plugin_url = trailingslashit( get_template_directory_uri() . $relative_url );
		$skin_care_solutions_current_theme = wp_get_theme();
		$this->skin_care_solutions_theme_title = $skin_care_solutions_current_theme->get( 'Name' );
		$this->skin_care_solutions_theme_name = strtolower( preg_replace( '#[^a-zA-Z]#', '', $skin_care_solutions_current_theme->get( 'Name' ) ) );
		$this->skin_care_solutions_page_slug = apply_filters( $this->skin_care_solutions_theme_name . '_theme_setup_wizard_skin_care_solutions_page_slug', $this->skin_care_solutions_theme_name . '-wizard' );
		$this->parent_slug = apply_filters( $this->skin_care_solutions_theme_name . '_theme_setup_wizard_parent_slug', '' );

	}
	
	/**
	 * Hooks and filters
	 * @since 1.0.0
	 */	
	public function init() {
		
		if ( class_exists( 'TGM_Plugin_Activation' ) && isset( $GLOBALS['tgmpa'] ) ) {
			add_action( 'init', array( $this, 'get_tgmpa_instance' ), 30 );
			add_action( 'init', array( $this, 'set_tgmpa_url' ), 40 );
		}
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'admin_menu', array( $this, 'menu_page' ) );
		add_action( 'admin_init', array( $this, 'get_plugins' ), 30 );
		add_filter( 'tgmpa_load', array( $this, 'tgmpa_load' ), 10, 1 );
		add_action( 'wp_ajax_setup_plugins', array( $this, 'setup_plugins' ) );
		add_action( 'wp_ajax_skin_care_solutions_setup_widgets', array( $this, 'skin_care_solutions_setup_widgets' ) );
		
	}
	
	public function enqueue_scripts() {
		wp_enqueue_style( 'skin-care-solutions-homepage-setup-style', get_template_directory_uri() . '/inc/homepage-setup/assets/css/homepage-setup-style.css');
		wp_register_script( 'skin-care-solutions-homepage-setup-script', get_template_directory_uri() . '/inc/homepage-setup/assets/js/homepage-setup-script.js', array( 'jquery' ), time() );
		wp_localize_script( 
			'skin-care-solutions-homepage-setup-script',
			'whizzie_params',
			array(
				'ajaxurl' 		=> admin_url( 'admin-ajax.php' ),
				'wpnonce' 		=> wp_create_nonce( 'whizzie_nonce' ),
				'verify_text'	=> esc_html( 'verifying', 'skin-care-solutions' )
			)
		);
		wp_enqueue_script( 'skin-care-solutions-homepage-setup-script' );
	}
	
	public static function get_instance() {
		if ( ! self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	
	public function tgmpa_load( $status ) {
		return is_admin() || current_user_can( 'install_themes' );
	}
			
	/**
	 * Get configured TGMPA instance
	 *
	 * @access public
	 * @since 1.1.2
	 */
	public function get_tgmpa_instance() {
		$this->tgmpa_instance = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );
	}
	
	/**
	 * Update $tgmpa_menu_slug and $tgmpa_parent_slug from TGMPA instance
	 *
	 * @access public
	 * @since 1.1.2
	 */
	public function set_tgmpa_url() {
		$this->tgmpa_menu_slug = ( property_exists( $this->tgmpa_instance, 'menu' ) ) ? $this->tgmpa_instance->menu : $this->tgmpa_menu_slug;
		$this->tgmpa_menu_slug = apply_filters( $this->skin_care_solutions_theme_name . '_theme_setup_wizard_tgmpa_menu_slug', $this->tgmpa_menu_slug );
		$tgmpa_parent_slug = ( property_exists( $this->tgmpa_instance, 'parent_slug' ) && $this->tgmpa_instance->parent_slug !== 'themes.php' ) ? 'admin.php' : 'themes.php';
		$this->tgmpa_url = apply_filters( $this->skin_care_solutions_theme_name . '_theme_setup_wizard_tgmpa_url', $tgmpa_parent_slug . '?page=' . $this->tgmpa_menu_slug );
	}
	
	/**
	 * Make a modal screen for the wizard
	 */
	public function menu_page() {
		add_theme_page( esc_html( $this->skin_care_solutions_page_title ), esc_html( $this->skin_care_solutions_page_title ), 'manage_options', $this->skin_care_solutions_page_slug, array( $this, 'wizard_page' ) );
	}
	
	/**
	 * Make an interface for the wizard
	 */
	public function wizard_page() { 
		tgmpa_load_bulk_installer();

		if ( ! class_exists( 'TGM_Plugin_Activation' ) || ! isset( $GLOBALS['tgmpa'] ) ) {
			die( esc_html__( 'Failed to find TGM', 'skin-care-solutions' ) );
		}

		$url = wp_nonce_url( add_query_arg( array( 'plugins' => 'go' ) ), 'whizzie-setup' );
		$method = '';
		$fields = array_keys( $_POST );

		if ( false === ( $creds = request_filesystem_credentials( esc_url_raw( $url ), $method, false, false, $fields ) ) ) {
			return true;
		}

		if ( ! WP_Filesystem( $creds ) ) {
			request_filesystem_credentials( esc_url_raw( $url ), $method, true, false, $fields );
			return true;
		}

		$skin_care_solutions_theme = wp_get_theme();
		$skin_care_solutions_theme_title = $skin_care_solutions_theme->get( 'Name' );
		$skin_care_solutions_theme_version = $skin_care_solutions_theme->get( 'Version' );

		?>
		<div class="wrap">
			<?php
				printf( '<h1>%s %s</h1>', esc_html( $skin_care_solutions_theme_title ), esc_html( '(Version :- ' . $skin_care_solutions_theme_version . ')' ) );
			?>
			<div class="homepage-setup">
				<div class="homepage-setup-theme-bundle">
					<div class="homepage-setup-theme-bundle-one">
						<h1><?php echo esc_html__( 'WP Theme Bundle', 'skin-care-solutions' ); ?></h1>
						<p><?php echo wp_kses_post( 'Get <span>15% OFF</span> on all WordPress themes! Use code <span>"BNDL15OFF"</span> at checkout. Limited time offer!' ); ?></p>
					</div>
					<div class="homepage-setup-theme-bundle-two">
						<p><?php echo wp_kses_post( 'Extra <span>15%</span> OFF' ); ?></p>
					</div>
					<div class="homepage-setup-theme-bundle-three">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/bundle-banner.png' ); ?>" alt="<?php echo esc_attr__( 'Theme Bundle Image', 'skin-care-solutions' ); ?>">
					</div>
					<div class="homepage-setup-theme-bundle-four">
						<p><?php echo wp_kses_post( '<span>$2795</span>$69' ); ?></p>
						<a target="_blank" href="<?php echo esc_url( SKIN_CARE_SOLUTIONS_BUNDLE_BUTTON ); ?>"><?php echo esc_html__( 'SHOP NOW', 'skin-care-solutions' ); ?> <span class="dashicons dashicons-arrow-right-alt2"></span></a>
					</div>
				</div>
			</div>
			
			<div class="card whizzie-wrap">
				<div class="demo_content_image">
					<div class="demo_content">
						<?php
							$skin_care_solutions_steps = $this->get_steps();
							echo '<ul class="whizzie-menu">';
							foreach ( $skin_care_solutions_steps as $skin_care_solutions_step ) {
								$class = 'step step-' . esc_attr( $skin_care_solutions_step['id'] );
								echo '<li data-step="' . esc_attr( $skin_care_solutions_step['id'] ) . '" class="' . esc_attr( $class ) . '">';
								printf( '<h2>%s</h2>', esc_html( $skin_care_solutions_step['title'] ) );

								$content = call_user_func( array( $this, $skin_care_solutions_step['view'] ) );
								if ( isset( $content['summary'] ) ) {
									printf(
										'<div class="summary">%s</div>',
										wp_kses_post( $content['summary'] )
									);
								}
								if ( isset( $content['detail'] ) ) {
									printf(
										'<div class="detail">%s</div>',
										wp_kses_post( $content['detail'] )
									);
								}
								if ( isset( $skin_care_solutions_step['button_text'] ) && $skin_care_solutions_step['button_text'] ) {
									printf( 
										'<div class="button-wrap"><a href="#" class="button button-primary do-it" data-callback="%s" data-step="%s">%s</a></div>',
										esc_attr( $skin_care_solutions_step['callback'] ),
										esc_attr( $skin_care_solutions_step['id'] ),
										esc_html( $skin_care_solutions_step['button_text'] )
									);
								}
								echo '</li>';
							}
							echo '</ul>';
						?>
						
						<ul class="whizzie-nav">
							<?php
							$step_number = 1;	
							foreach ( $skin_care_solutions_steps as $skin_care_solutions_step ) {
								echo '<li class="nav-step-' . esc_attr( $skin_care_solutions_step['id'] ) . '">';
								echo '<span class="step-number">' . esc_html( $step_number ) . '</span>';
								echo '</li>';
								$step_number++;
							}
							?>
							<div class="blank-border"></div>
						</ul>

						<div class="homepage-setup-links">
							<div class="homepage-setup-links buttons">
								<a href="<?php echo esc_url( SKIN_CARE_SOLUTIONS_LITE_DOCS_PRO ); ?>" target="_blank" class="button button-primary"><?php echo esc_html__( 'Free Documentation', 'skin-care-solutions' ); ?></a>
								<a href="<?php echo esc_url( SKIN_CARE_SOLUTIONS_BUY_NOW ); ?>" class="button button-primary" target="_blank"><?php echo esc_html__( 'Get Premium', 'skin-care-solutions' ); ?></a>
								<a href="<?php echo esc_url( SKIN_CARE_SOLUTIONS_DEMO_PRO ); ?>" class="button button-primary" target="_blank"><?php echo esc_html__( 'Premium Demo', 'skin-care-solutions' ); ?></a>
								<a href="<?php echo esc_url( SKIN_CARE_SOLUTIONS_SUPPORT_FREE ); ?>" target="_blank" class="button button-primary"><?php echo esc_html__( 'Support Forum', 'skin-care-solutions' ); ?></a>
							</div>
						</div> <!-- .demo_image -->

						<div class="step-loading"><span class="spinner"></span></div>
					</div> <!-- .demo_content -->

					<div class="homepage-setup-image">
						<div class="homepage-setup-theme-buynow">
							<div class="homepage-setup-theme-buynow-one">
								<h1><?php echo wp_kses_post( 'Skin Care<br>WordPress Theme' ); ?></h1>
								<p><?php echo wp_kses_post( '<span>25%<br>Off</span> SHOP NOW' ); ?></p>
							</div>
							<div class="homepage-setup-theme-buynow-two">
								<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/skin-care-solutions.png' ); ?>" alt="<?php echo esc_attr__( 'Theme Bundle Image', 'skin-care-solutions' ); ?>">
							</div>
							<div class="homepage-setup-theme-buynow-three">
								<p><?php echo wp_kses_post( 'Get <span>25% OFF</span> on Premium Skin Care WordPress Theme Use code <span>"NYTHEMES25"</span> at checkout.' ); ?></p>
							</div>
							<div class="homepage-setup-theme-buynow-four">
								<a target="_blank" href="<?php echo esc_url( SKIN_CARE_SOLUTIONS_BUY_NOW ); ?>"><?php echo esc_html__( 'Upgrade To Pro With Just $40', 'skin-care-solutions' ); ?></a>
							</div>
						</div>
					</div> <!-- .demo_image -->

				</div> <!-- .demo_content_image -->
			</div> <!-- .whizzie-wrap -->
		</div> <!-- .wrap -->
		<?php
	}


	/**
	 * Set options for the steps
	 * Incorporate any options set by the theme dev
	 * Return the array for the steps
	 * @return Array
	 */
	public function get_steps() {
		$skin_care_solutions_dev_steps = $this->config_steps;
		$skin_care_solutions_steps = array( 
			'plugins' => array(
				'id'			=> 'plugins',
				'title'			=> __( 'Install and Activate Essential Plugins', 'skin-care-solutions' ),
				'icon'			=> 'admin-plugins',
				'view'			=> 'get_step_plugins',
				'callback'		=> 'install_plugins',
				'button_text'	=> __( 'Install Plugins', 'skin-care-solutions' ),
				'can_skip'		=> true
			),
			'widgets' => array(
				'id'			=> 'widgets',
				'title'			=> __( 'Setup Home Page', 'skin-care-solutions' ),
				'icon'			=> 'welcome-widgets-menus',
				'view'			=> 'get_step_widgets',
				'callback'		=> 'skin_care_solutions_install_widgets',
				'button_text'	=> __( 'Start Home Page Setup', 'skin-care-solutions' ),
				'can_skip'		=> false
			),
			'done' => array(
				'id'			=> 'done',
				'title'			=> __( 'Customize Your Site', 'skin-care-solutions' ),
				'icon'			=> 'yes',
				'view'			=> 'get_step_done',
				'callback'		=> ''
			)
		);
		
		// Iterate through each step and replace with dev config values
		if( $skin_care_solutions_dev_steps ) {
			// Configurable elements - these are the only ones the dev can update from homepage-setup-settings.php
			$can_config = array( 'title', 'icon', 'button_text', 'can_skip' );
			foreach( $skin_care_solutions_dev_steps as $skin_care_solutions_dev_step ) {
				// We can only proceed if an ID exists and matches one of our IDs
				if( isset( $skin_care_solutions_dev_step['id'] ) ) {
					$id = $skin_care_solutions_dev_step['id'];
					if( isset( $skin_care_solutions_steps[$id] ) ) {
						foreach( $can_config as $element ) {
							if( isset( $skin_care_solutions_dev_step[$element] ) ) {
								$skin_care_solutions_steps[$id][$element] = $skin_care_solutions_dev_step[$element];
							}
						}
					}
				}
			}
		}
		return $skin_care_solutions_steps;
	}

	/**
	 * Get the content for the plugins step
	 * @return $content Array
	 */
	public function get_step_plugins() {
		$plugins = $this->get_plugins();
		$content = array(); 
		
		// Add plugin name and type at the top
		$content['detail'] = '<div class="plugin-info">';
		$content['detail'] .= '<p><strong>Plugin</strong></p>';
		$content['detail'] .= '<p><strong>Type</strong></p>';
		$content['detail'] .= '</div>';
		
		// The detail element is initially hidden from the user
		$content['detail'] .= '<ul class="whizzie-do-plugins">';
		
		// Add each plugin into a list
		foreach( $plugins['all'] as $slug=>$plugin ) {
			$content['detail'] .= '<li data-slug="' . esc_attr( $slug ) . '">' . esc_html( $plugin['name'] ) . '<span>';
			$keys = array();
			if ( isset( $plugins['install'][ $slug ] ) ) {
				$keys[] = 'Installation';
			}
			if ( isset( $plugins['update'][ $slug ] ) ) {
				$keys[] = 'Update';
			}
			if ( isset( $plugins['activate'][ $slug ] ) ) {
				$keys[] = 'Activation';
			}
			$content['detail'] .= implode( ' and ', $keys ) . ' required';
			$content['detail'] .= '</span></li>';
		}
		
		$content['detail'] .= '</ul>';
		
		return $content;
	}
	
	/**
	 * Print the content for the widgets step
	 * @since 1.1.0
	 */
	public function get_step_widgets() { ?> <?php }
	
	/**
	 * Print the content for the final step
	 */
	public function get_step_done() { ?>
		<div id="skin-care-solutions-demo-setup-guid">
			<div class="customize_div">
				<div class="customize_div finish">
					<div class="customize_div finish btns">
						<h3><?php echo esc_html( 'Your Site Is Ready To View' ); ?></h3>
						<div class="btnsss">
							<a target="_blank" href="<?php echo esc_url( get_home_url() ); ?>" class="button button-primary">
								<?php esc_html_e( 'View Your Site', 'skin-care-solutions' ); ?>
							</a>
							<a target="_blank" href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>" class="button button-primary">
								<?php esc_html_e( 'Customize Your Site', 'skin-care-solutions' ); ?>
							</a>
							<a href="<?php echo esc_url(admin_url()); ?>" class="button button-primary">
								<?php esc_html_e( 'Finsh', 'skin-care-solutions' ); ?>
							</a>
						</div>
					</div>
					<div class="skin-care-solutions-setup-finish">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/screenshot.png' ); ?>"/>
					</div>
				</div>
			</div>
		</div>
	<?php }

	/**
	 * Get the plugins registered with TGMPA
	 */
	public function get_plugins() {
		$instance = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );
		$plugins = array(
			'all' 		=> array(),
			'install'	=> array(),
			'update'	=> array(),
			'activate'	=> array()
		);
		foreach( $instance->plugins as $slug=>$plugin ) {
			if( $instance->is_plugin_active( $slug ) && false === $instance->does_plugin_have_update( $slug ) ) {
				// Plugin is installed and up to date
				continue;
			} else {
				$plugins['all'][$slug] = $plugin;
				if( ! $instance->is_plugin_installed( $slug ) ) {
					$plugins['install'][$slug] = $plugin;
				} else {
					if( false !== $instance->does_plugin_have_update( $slug ) ) {
						$plugins['update'][$slug] = $plugin;
					}
					if( $instance->can_plugin_activate( $slug ) ) {
						$plugins['activate'][$slug] = $plugin;
					}
				}
			}
		}
		return $plugins;
	}

	/**
	 * Get the widgets.wie file from the /content folder
	 * @return Mixed	Either the file or false
	 * @since 1.1.0
	 */
	public function has_widget_file() {
		if( file_exists( $this->widget_file_url ) ) {
			return true;
		}
		return false;
	}
	
	public function setup_plugins() {
		if ( ! check_ajax_referer( 'whizzie_nonce', 'wpnonce' ) || empty( $_POST['slug'] ) ) {
			wp_send_json_error( array( 'error' => 1, 'message' => esc_html__( 'No Slug Found','skin-care-solutions' ) ) );
		}
		$json = array();
		// send back some json we use to hit up TGM
		$plugins = $this->get_plugins();
		
		// what are we doing with this plugin?
		foreach ( $plugins['activate'] as $slug => $plugin ) {
			if ( $_POST['slug'] == $slug ) {
				$json = array(
					'url'           => admin_url( $this->tgmpa_url ),
					'plugin'        => array( $slug ),
					'tgmpa-page'    => $this->tgmpa_menu_slug,
					'plugin_status' => 'all',
					'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
					'action'        => 'tgmpa-bulk-activate',
					'action2'       => - 1,
					'message'       => esc_html__( 'Activating Plugin','skin-care-solutions' ),
				);
				break;
			}
		}
		foreach ( $plugins['update'] as $slug => $plugin ) {
			if ( $_POST['slug'] == $slug ) {
				$json = array(
					'url'           => admin_url( $this->tgmpa_url ),
					'plugin'        => array( $slug ),
					'tgmpa-page'    => $this->tgmpa_menu_slug,
					'plugin_status' => 'all',
					'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
					'action'        => 'tgmpa-bulk-update',
					'action2'       => - 1,
					'message'       => esc_html__( 'Updating Plugin','skin-care-solutions' ),
				);
				break;
			}
		}
		foreach ( $plugins['install'] as $slug => $plugin ) {
			if ( $_POST['slug'] == $slug ) {
				$json = array(
					'url'           => admin_url( $this->tgmpa_url ),
					'plugin'        => array( $slug ),
					'tgmpa-page'    => $this->tgmpa_menu_slug,
					'plugin_status' => 'all',
					'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
					'action'        => 'tgmpa-bulk-install',
					'action2'       => - 1,
					'message'       => esc_html__( 'Installing Plugin','skin-care-solutions' ),
				);
				break;
			}
		}
		if ( $json ) {
			$json['hash'] = md5( serialize( $json ) ); // used for checking if duplicates happen, move to next plugin
			wp_send_json( $json );
		} else {
			wp_send_json( array( 'done' => 1, 'message' => esc_html__( 'Success','skin-care-solutions' ) ) );
		}
		exit;
	}


	public function skin_care_solutions_customizer_nav_menu() {

		/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- Skin Care Solutions Primary Menu -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/

		$skin_care_solutions_themename = 'Skin Care Solutions';
		$skin_care_solutions_menuname = $skin_care_solutions_themename . ' Primary Menu';
		$skin_care_solutions_menulocation = 'skin-care-solutions-primary-menu';
		$skin_care_solutions_menu_exists = wp_get_nav_menu_object($skin_care_solutions_menuname);

		if (!$skin_care_solutions_menu_exists) {
			$skin_care_solutions_menu_id = wp_create_nav_menu($skin_care_solutions_menuname);

			// Home
			wp_update_nav_menu_item($skin_care_solutions_menu_id, 0, array(
				'menu-item-title' => __('Home', 'skin-care-solutions'),
				'menu-item-classes' => 'home',
				'menu-item-url' => home_url('/'),
				'menu-item-status' => 'publish'
			));

			// About
			$skin_care_solutions_page_about = get_page_by_path('about');
			if($skin_care_solutions_page_about){
				wp_update_nav_menu_item($skin_care_solutions_menu_id, 0, array(
					'menu-item-title' => __('About', 'skin-care-solutions'),
					'menu-item-classes' => 'about',
					'menu-item-url' => get_permalink($skin_care_solutions_page_about),
					'menu-item-status' => 'publish'
				));
			}

			// Services
			$skin_care_solutions_page_services = get_page_by_path('services');
			if($skin_care_solutions_page_services){
				wp_update_nav_menu_item($skin_care_solutions_menu_id, 0, array(
					'menu-item-title' => __('Services', 'skin-care-solutions'),
					'menu-item-classes' => 'services',
					'menu-item-url' => get_permalink($skin_care_solutions_page_services),
					'menu-item-status' => 'publish'
				));
			}

			// Shop Page (WooCommerce)
			if (class_exists('WooCommerce')) {
				$skin_care_solutions_shop_page_id = wc_get_page_id('shop');
				if ($skin_care_solutions_shop_page_id) {
					wp_update_nav_menu_item($skin_care_solutions_menu_id, 0, array(
						'menu-item-title' => __('Shop', 'skin-care-solutions'),
						'menu-item-classes' => 'shop',
						'menu-item-url' => get_permalink($skin_care_solutions_shop_page_id),
						'menu-item-status' => 'publish'
					));
				}
			}

			// Blog
			$skin_care_solutions_page_blog = get_page_by_path('blog');
			if($skin_care_solutions_page_blog){
				wp_update_nav_menu_item($skin_care_solutions_menu_id, 0, array(
					'menu-item-title' => __('Blog', 'skin-care-solutions'),
					'menu-item-classes' => 'blog',
					'menu-item-url' => get_permalink($skin_care_solutions_page_blog),
					'menu-item-status' => 'publish'
				));
			}

			// 404 Page
			$skin_care_solutions_notfound = get_page_by_path('404 Page');
			if($skin_care_solutions_notfound){
				wp_update_nav_menu_item($skin_care_solutions_menu_id, 0, array(
					'menu-item-title' => __('404 Page', 'skin-care-solutions'),
					'menu-item-classes' => '404',
					'menu-item-url' => get_permalink($skin_care_solutions_notfound),
					'menu-item-status' => 'publish'
				));
			}

			if (!has_nav_menu($skin_care_solutions_menulocation)) {
				$skin_care_solutions_locations = get_theme_mod('nav_menu_locations');
				$skin_care_solutions_locations[$skin_care_solutions_menulocation] = $skin_care_solutions_menu_id;
				set_theme_mod('nav_menu_locations', $skin_care_solutions_locations);
			}
		}
	}

	
	/**
	 * Imports the Demo Content
	 * @since 1.1.0
	 */
	public function skin_care_solutions_setup_widgets(){

		/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- MENUS PAGES -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/
		
			// Creation of home page //
			$skin_care_solutions_home_content = '';
			$skin_care_solutions_home_title = 'Home';
			$skin_care_solutions_home = array(
					'post_type' => 'page',
					'post_title' => $skin_care_solutions_home_title,
					'post_content'  => $skin_care_solutions_home_content,
					'post_status' => 'publish',
					'post_author' => 1,
					'post_slug' => 'home'
			);
			$skin_care_solutions_home_id = wp_insert_post($skin_care_solutions_home);

			add_post_meta( $skin_care_solutions_home_id, '_wp_page_template', 'frontpage.php' );

			$skin_care_solutions_home = get_page_by_path( 'Home' );
			update_option( 'page_on_front', $skin_care_solutions_home->ID );
			update_option( 'show_on_front', 'page' );

			// Creation of blog page //
			$skin_care_solutions_blog_title = 'Blog';
			$skin_care_solutions_blog_check = get_page_by_path('blog');
			if (!$skin_care_solutions_blog_check) {
				$skin_care_solutions_blog = array(
					'post_type'    => 'page',
					'post_title'   => $skin_care_solutions_blog_title,
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_name'    => 'blog'
				);
				$skin_care_solutions_blog_id = wp_insert_post($skin_care_solutions_blog);

				if (!is_wp_error($skin_care_solutions_blog_id)) {
					update_option('page_for_posts', $skin_care_solutions_blog_id);
				}
			}

			// Creation of about page //
			$skin_care_solutions_about_title = 'About';
			$skin_care_solutions_about_content = 'What is Lorem Ipsum?
														Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
			$skin_care_solutions_about_check = get_page_by_path('about');
			if (!$skin_care_solutions_about_check) {
				$skin_care_solutions_about = array(
					'post_type'    => 'page',
					'post_title'   => $skin_care_solutions_about_title,
					'post_content'   => $skin_care_solutions_about_content,
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_name'    => 'about'
				);
				wp_insert_post($skin_care_solutions_about);
			}

			// Creation of services page //
			$skin_care_solutions_services_title = 'Services';
			$skin_care_solutions_services_content = 'What is Lorem Ipsum?
														Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
			$skin_care_solutions_services_check = get_page_by_path('services');
			if (!$skin_care_solutions_services_check) {
				$skin_care_solutions_services = array(
					'post_type'    => 'page',
					'post_title'   => $skin_care_solutions_services_title,
					'post_content'   => $skin_care_solutions_services_content,
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_name'    => 'services'
				);
				wp_insert_post($skin_care_solutions_services);
			}

			// Creation of 404 page //
			$skin_care_solutions_notfound_title = '404 Page';
			$skin_care_solutions_notfound = array(
				'post_type'   => 'page',
				'post_title'  => $skin_care_solutions_notfound_title,
				'post_status' => 'publish',
				'post_author' => 1,
				'post_slug'   => '404'
			);
			$skin_care_solutions_notfound_id = wp_insert_post($skin_care_solutions_notfound);
			add_post_meta($skin_care_solutions_notfound_id, '_wp_page_template', '404.php');



			/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- SLIDER POST -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/

				$skin_care_solutions_slider_title = array('Get The Perfect Skin You Wish');
				for($skin_care_solutions_i=1;$skin_care_solutions_i<=1;$skin_care_solutions_i++){

					$skin_care_solutions_title = $skin_care_solutions_slider_title[$skin_care_solutions_i-1];
					$skin_care_solutions_content = 'Skincare & Dermatology';

					// Create post object
					$skin_care_solutions_my_post = array(
							'post_title'    => wp_strip_all_tags( $skin_care_solutions_title ),
							'post_content'  => $skin_care_solutions_content,
							'post_status'   => 'publish',
							'post_type'     => 'post',
					);
					// Insert the post into the database
					$skin_care_solutions_post_id = wp_insert_post( $skin_care_solutions_my_post );

					wp_set_object_terms($skin_care_solutions_post_id, 'Slider', 'category', true);

					wp_set_object_terms($skin_care_solutions_post_id, 'Slider', 'post_tag', true);

					$skin_care_solutions_image_url = get_template_directory_uri().'/inc/homepage-setup/assets/homepage-setup-images/slider-img'.$skin_care_solutions_i.'.png';

					$skin_care_solutions_image_name= 'slider-img'.$skin_care_solutions_i.'.png';
					$upload_dir       = wp_upload_dir();
					// Set upload folder
					$skin_care_solutions_image_data       = file_get_contents($skin_care_solutions_image_url);
					// Get image data
					$skin_care_solutions_unique_file_name = wp_unique_filename( $upload_dir['path'], $skin_care_solutions_image_name );

					$skin_care_solutions_filename = basename( $skin_care_solutions_unique_file_name ); 
					
					// Check folder permission and define file location
					if( wp_mkdir_p( $upload_dir['path'] ) ) {
							$skin_care_solutions_file = $upload_dir['path'] . '/' . $skin_care_solutions_filename;
					} else {
							$skin_care_solutions_file = $upload_dir['basedir'] . '/' . $skin_care_solutions_filename;
					}
					// Create the image  file on the server
					// Generate unique name
					if ( ! function_exists( 'WP_Filesystem' ) ) {
						require_once( ABSPATH . 'wp-admin/includes/file.php' );
					}
					
					WP_Filesystem();
					global $wp_filesystem;
					
					if ( ! $wp_filesystem->put_contents( $skin_care_solutions_file, $skin_care_solutions_image_data, FS_CHMOD_FILE ) ) {
						wp_die( 'Error saving file!' );
					}
					// Check image file type
					$wp_filetype = wp_check_filetype( $skin_care_solutions_filename, null );
					// Set attachment data
					$skin_care_solutions_attachment = array(
							'post_mime_type' => $wp_filetype['type'],
							'post_title'     => sanitize_file_name( $skin_care_solutions_filename ),
							'post_content'   => '',
							'post_type'     => 'post',
							'post_status'    => 'inherit'
					);
					// Create the attachment
					$skin_care_solutions_attach_id = wp_insert_attachment( $skin_care_solutions_attachment, $skin_care_solutions_file, $skin_care_solutions_post_id );
					// Include image.php
					require_once(ABSPATH . 'wp-admin/includes/image.php');
					// Define attachment metadata
					$skin_care_solutions_attach_data = wp_generate_attachment_metadata( $skin_care_solutions_attach_id, $skin_care_solutions_file );
					// Assign metadata to attachment
						wp_update_attachment_metadata( $skin_care_solutions_attach_id, $skin_care_solutions_attach_data );
					// And finally assign featured image to post
					set_post_thumbnail( $skin_care_solutions_post_id, $skin_care_solutions_attach_id );

	 			}


			/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- PRODUCTS -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/
			
				$skin_care_solutions_uncategorized_term = get_term_by('name', 'Uncategorized', 'product_cat');
				if ($skin_care_solutions_uncategorized_term) {
					wp_delete_term($skin_care_solutions_uncategorized_term->term_id, 'product_cat');
				}

				$skin_care_solutions_product_category= array(
					'Skincare' => array(
								'Product Title 1',
								'Product Title 2',
								'Product Title 3',
								'Product Title 4',
					)
				);
				$skin_care_solutions_i = 1;
				foreach ( $skin_care_solutions_product_category as $skin_care_solutions_product_cats => $skin_care_solutions_products_name ) {

					// Insert porduct cats Start
					$skin_care_solutions_content = 'Lorem ipsum dolor sit amet';
					$skin_care_solutions_parent_category	=	wp_insert_term(
					$skin_care_solutions_product_cats, // the term
					'product_cat', // the taxonomy
					array(
						'description'=> $skin_care_solutions_content,
						'slug' => 'product_cat'.$skin_care_solutions_i
					));

					$skin_care_solutions_image_url = get_template_directory_uri().'/inc/homepage-setup/assets/homepage-setup-images/slider-img'.$skin_care_solutions_i.'.png';

					$skin_care_solutions_image_name= 'slider-img'.$skin_care_solutions_i.'.png';
					$upload_dir       = wp_upload_dir();
					// Set upload folder
					$skin_care_solutions_image_data= file_get_contents($skin_care_solutions_image_url);
					// Get image data
					$skin_care_solutions_unique_file_name = wp_unique_filename( $upload_dir['path'], $skin_care_solutions_image_name );
					// Generate unique name
					$skin_care_solutions_filename= basename( $skin_care_solutions_unique_file_name );
					// Create image file name

					// Check folder permission and define file location
					if( wp_mkdir_p( $upload_dir['path'] ) ) {
					$file = $upload_dir['path'] . '/' . $skin_care_solutions_filename;
					} else {
					$file = $upload_dir['basedir'] . '/' . $skin_care_solutions_filename;
					}

					// Create the image  file on the server
					if ( ! function_exists( 'WP_Filesystem' ) ) {
						require_once( ABSPATH . 'wp-admin/includes/file.php' );
					}
					
					WP_Filesystem();
					global $wp_filesystem;
					
					if ( ! $wp_filesystem->put_contents( $file, $skin_care_solutions_image_data, FS_CHMOD_FILE ) ) {
						wp_die( 'Error saving file!' );
					}
					
					// Check image file type
					$wp_filetype = wp_check_filetype( $skin_care_solutions_filename, null );

					// Set attachment data
					$skin_care_solutions_attachment = array(
					'post_mime_type' => $wp_filetype['type'],
					'post_title'     => sanitize_file_name( $skin_care_solutions_filename ),
					'post_content'   => '',
					'post_type'     => 'product',
					'post_status'    => 'inherit'
					);

					// Create the attachment
					$skin_care_solutions_attach_id = wp_insert_attachment( $skin_care_solutions_attachment, $file, $post_id );

					// Include image.php
					require_once(ABSPATH . 'wp-admin/includes/image.php');

					// Define attachment metadata
					$skin_care_solutions_attach_data = wp_generate_attachment_metadata( $skin_care_solutions_attach_id, $file );

					// Assign metadata to attachment
					wp_update_attachment_metadata( $skin_care_solutions_attach_id, $skin_care_solutions_attach_data );

					update_woocommerce_term_meta( $skin_care_solutions_parent_category['term_id'], 'thumbnail_id', $skin_care_solutions_attach_id );

					// create Product START
					foreach ( $skin_care_solutions_products_name as $key => $skin_care_solutions_product_title ) {

						$skin_care_solutions_content = 'Te obtinuit ut adepto satis somno.';
						// Create post object
						$my_post = array(
							'post_title'    => wp_strip_all_tags( $skin_care_solutions_product_title ),
							'post_content'  => $skin_care_solutions_content,
							'post_status'   => 'publish',
							'post_type'     => 'product',
						);

						// Insert the post into the database
						$post_id    = wp_insert_post($my_post);

						wp_set_object_terms( $post_id, 'product_cat' . $skin_care_solutions_i, 'product_cat', true );

						update_post_meta($post_id, '_regular_price', '95');
						update_post_meta($post_id, '_sale_price', '70');
						update_post_meta($post_id, '_price', '70');

						// Now replace meta w/ new updated value array
						$skin_care_solutions_image_url = get_template_directory_uri().'/inc/homepage-setup/assets/homepage-setup-images/'.str_replace( " ", "-", $skin_care_solutions_product_title).'.png';

						echo $skin_care_solutions_image_url . "<br>";

						$skin_care_solutions_image_name       = $skin_care_solutions_product_title.'.png';
						$upload_dir = wp_upload_dir();
						// Set upload folder
						$skin_care_solutions_image_data = file_get_contents(esc_url($skin_care_solutions_image_url));

						// Get image data
						$skin_care_solutions_unique_file_name = wp_unique_filename($upload_dir['path'], $skin_care_solutions_image_name);
						// Generate unique name
						$skin_care_solutions_filename = basename($skin_care_solutions_unique_file_name);
						// Create image file name

						// Check folder permission and define file location
						if (wp_mkdir_p($upload_dir['path'])) {
							$file = $upload_dir['path'].'/'.$skin_care_solutions_filename;
						} else {
							$file = $upload_dir['basedir'].'/'.$skin_care_solutions_filename;
						}

						// Create the image  file on the server
						if ( ! function_exists( 'WP_Filesystem' ) ) {
							require_once( ABSPATH . 'wp-admin/includes/file.php' );
						}
						
						WP_Filesystem();
						global $wp_filesystem;
						
						if ( ! $wp_filesystem->put_contents( $file, $skin_care_solutions_image_data, FS_CHMOD_FILE ) ) {
							wp_die( 'Error saving file!' );
						}

						// Check image file type
						$wp_filetype = wp_check_filetype($skin_care_solutions_filename, null);

						// Set attachment data
						$skin_care_solutions_attachment = array(
							'post_mime_type' => $wp_filetype['type'],
							'post_title'     => sanitize_file_name($skin_care_solutions_filename),
							'post_type'      => 'product',
							'post_status'    => 'inherit',
						);

						// Create the attachment
						$skin_care_solutions_attach_id = wp_insert_attachment($skin_care_solutions_attachment, $file, $post_id);

						// Include image.php
						require_once (ABSPATH.'wp-admin/includes/image.php');

						// Define attachment metadata
						$skin_care_solutions_attach_data = wp_generate_attachment_metadata($skin_care_solutions_attach_id, $file);

						// Assign metadata to attachment
						wp_update_attachment_metadata($skin_care_solutions_attach_id, $skin_care_solutions_attach_data);

						// And finally assign featured image to post
						set_post_thumbnail($post_id, $skin_care_solutions_attach_id);
					}
					// Create product END
					++$skin_care_solutions_i;
				}

        
        $this->skin_care_solutions_customizer_nav_menu();

	    exit;
	}
}