<?php
/**
 * Settings for demo import
 *
 */

/**
 * Define constants
 **/
if ( ! defined( 'WHIZZIE_DIR' ) ) {
	define( 'WHIZZIE_DIR', dirname( __FILE__ ) );
}
require trailingslashit( WHIZZIE_DIR ) . 'homepage-setup-contents.php';
$skin_care_solutions_current_theme = wp_get_theme();
$skin_care_solutions_theme_title = $skin_care_solutions_current_theme->get( 'Name' );


/**
 * Make changes below
 **/

// Change the title and slug of your wizard page
$config['skin_care_solutions_page_slug'] 	= 'skin-care-solutions';
$config['skin_care_solutions_page_title']	= 'Homepage Setup';

$config['steps'] = array(
	'plugins' => array(
		'id'			=> 'plugins',
		'title'			=> __( 'Install and Activate Essential Plugins', 'skin-care-solutions' ),
		'icon'			=> 'admin-plugins',
		'button_text'	=> __( 'Install Plugins', 'skin-care-solutions' ),
		'can_skip'		=> true
	),
	'widgets' => array(
		'id'			=> 'widgets',
		'title'			=> __( 'Setup Home Page', 'skin-care-solutions' ),
		'icon'			=> 'welcome-widgets-menus',
		'button_text'	=> __( 'Start Home Page Setup', 'skin-care-solutions' ),
		'can_skip'		=> true
	),
	'done' => array(
		'id'			=> 'done',
		'title'			=> __( 'Customize Your Site', 'skin-care-solutions' ),
		'icon'			=> 'yes',
	)
);

/**
 * This kicks off the wizard
 **/
if( class_exists( 'Skin_Care_Solutions_Whizzie' ) ) {
	$Skin_Care_Solutions_Whizzie = new Skin_Care_Solutions_Whizzie( $config );
}