<?php
/**
 * Template Name: Custom Home
 */

get_header(); ?>

<main id="main" class="site-main" role="main">
	<?php do_action( 'vivah_royal_wedding_above_banner' ); ?>

	<?php if(get_theme_mod('vivah_royal_wedding_show_banner',false) == true){?>
		<section id="banner">
		  	<?php $vivah_royal_wedding_slider_pages = array();
		      	for ( $count = 0; $count <= 0; $count++ ) {
			        $mod = absint( get_theme_mod( 'vivah_royal_wedding_page_settings' . $count ));
			        if ( 'page-none-selected' != $mod ) {
			          	$vivah_royal_wedding_slider_pages[] = $mod;
			        }
		      	}
		      	if( !empty($vivah_royal_wedding_slider_pages) ) :
			        $args = array(
			          'post_type' => 'page',
			          'post__in' => $vivah_royal_wedding_slider_pages,
			          'orderby' => 'post__in'
			        );
		    	$query = new WP_Query( $args );
		        if ( $query->have_posts() ) :
		          	$count = 0;
		          	while ( $query->have_posts() ) : $query->the_post(); ?>
		                <div class="box-image">
		                  	<a href="<?php echo esc_url( get_permalink() );?>">
		                  		<?php if(has_post_thumbnail()) {?>
	            					<img src="<?php esc_url(the_post_thumbnail_url('full')); ?>" alt="<?php the_title_attribute(); ?> "/>
	            				<?php } else {?>
	            					<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/slider.png" alt="<?php the_title_attribute(); ?> "/>
	            				<?php }?>
		                  	<span class="screen-reader-text"><?php the_title(); ?></span></a>
		                </div>
		              	<div class="box-content">
							<div class="box-contentbg"></div>
		                	<h1><a href="<?php echo esc_url( get_permalink() );?>"><?php the_title(); ?><span class="screen-reader-text"><?php the_title(); ?></span></a></h1>
		                </div>
		            <?php $count++; endwhile; ?>
		      	<?php else : ?>
		        	<div class="no-postfound"></div>
		        <?php endif;
		  	endif; wp_reset_postdata();?>
		</section>
	<?php }?>

	<?php do_action('vivah_royal_wedding_below_banner'); ?>

	<?php /*--Bride and Groom--*/?>
	<section id="bride-groom">
	    <div class="container">
	    	<?php if( get_theme_mod( 'vivah_royal_wedding_section_title','' ) != '') { ?>
				<h2><?php echo esc_html( get_theme_mod('vivah_royal_wedding_section_title','')); ?></h2>
				<img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/line.png'); ?>" alt="<?php esc_attr_e('Border Image','vivah-royal-wedding'); ?>"/>
		    <?php } ?>
	    	<div class="row">
		    	<?php $vivah_royal_wedding_bride_pages = array();
		    	for ( $count = 0; $count <= 1; $count++ ) {
			      	$mod = intval( get_theme_mod( 'vivah_royal_wedding_services' . $count ));
			     	if ( 'page-none-selected' != $mod ) {
			        	$vivah_royal_wedding_bride_pages[] = $mod;
			      	}
		    	}
		    	if( !empty($vivah_royal_wedding_bride_pages) ) :
		      	$args = array(
		        	'post_type' => 'page',
		        	'post__in' => $vivah_royal_wedding_bride_pages,
		        	'orderby' => 'post__in'
		      	);
		      	$query = new WP_Query( $args );
		     	if ( $query->have_posts() ) :
		        $count = 0;
		        while ( $query->have_posts() ) : $query->the_post(); ?>        	
		          	<div class="col-lg-6 col-md-6">
		          		<div class="service-image">
		                	<?php the_post_thumbnail(); ?>
		                	<div class="content">
			                	<h3><a href="<?php echo esc_url( get_permalink() );?>"><?php the_title(); ?><span class="screen-reader-text"><?php the_title(); ?></span></a></h3>  
			                    <p><?php $excerpt = get_the_excerpt(); echo esc_html( vivah_royal_wedding_string_limit_words( $excerpt,15 ) ); ?></p>
			                    <div class="clearfix"></div>
			                </div>		      	
		                </div>	
		          	</div>
		        <?php $count++; endwhile; 
		        wp_reset_postdata();?>
		      	<?php else : ?>
		          	<div class="no-postfound"></div>
		      	<?php endif;
		    	endif;?>
	      		<div class="clearfix"></div>
	      	</div>
	 	</div> 
	</section>

	<?php do_action('vivah_royal_wedding_after_bride_groom_section'); ?>

	<div class="container lz-content">
	  	<?php while ( have_posts() ) : the_post(); ?>
	        <?php the_content(); ?>
	    <?php endwhile; // end of the loop. ?>
	</div>
</main>

<?php get_footer(); ?>