<?php
/**
 * Template part for displaying posts
 * 
 * @subpackage vivah-royal-wedding
 * @since 1.0
 * @version 1.4
 */
?>
<?php 
  $archive_year  = get_the_time('Y'); 
  $archive_month = get_the_time('m'); 
  $archive_day   = get_the_time('d'); 
?>
<div class="col-lg-4 col-md-4">
	<div id="post-<?php the_ID(); ?>" <?php post_class('inner-service'); ?>>
    <div class="article_content">
      <?php the_post_thumbnail(); ?>
      <div class="article-text">
        <a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day)); ?>"><i class="far fa-calendar-alt"></i><span class="entry-date"><?php the_time( get_option( 'date_format' ) ); ?></span><span class="screen-reader-text"><?php the_time( get_option( 'date_format' ) ); ?></span></a>
        <h3><a href="<?php echo esc_url( get_permalink() );?>"><?php the_title(); ?><span class="screen-reader-text"><?php the_title(); ?></span></a></h3> 
        <div class="text-content"><p><?php $excerpt = get_the_excerpt();echo esc_html( vivah_royal_wedding_string_limit_words( $excerpt,30 ) ); ?></p></div>
        <div class="row">
          <div class="col-lg-6 col-md-6">
            <div class="metabox">
              <i class="fas fa-user"></i><a href="<?php echo esc_url( get_permalink() );?>"><span class="entry-author"><?php the_author(); ?></span></a>
              <i class="fas fa-comments"></i><span class="entry-comments"><?php comments_number( __('0 Comments','vivah-royal-wedding'), __('0 Comments','vivah-royal-wedding'), __('% Comments','vivah-royal-wedding') ); ?></span>
            </div>
          </div>
          <div class="col-lg-6 col-md-6">
            <div class="read-btn">
              <a href="<?php echo esc_url( get_permalink() );?>" class="blogbutton-small"><?php esc_html_e('READ MORE','vivah-royal-wedding'); ?><span class="screen-reader-text"><?php esc_html_e('READ MORE','vivah-royal-wedding'); ?></span>
              </a>
            </div>
          </div>
        </div>
      </div>
      <div class="clearfix"></div> 
    </div>
    <hr class="horizontal">
  </div>
</div>