<?php
function expert_gamer_blog_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
			'expert_gamer_frontpage_sections', array(
				'priority' => 32,
				'title' => esc_html__( 'Frontpage Sections', 'expert-gamer' ),
			)
		);
	
	/*=========================================
	Slider Section
	=========================================*/
	$wp_customize->add_section(
		'expert_gamer_slider_setting', array(
			'title' => esc_html__( 'Slider Section', 'expert-gamer' ),
			'priority' => 13,
			'panel' => 'expert_gamer_frontpage_sections',
		)
	);

	// Slider Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_slider_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_slider_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'expert-gamer' ),
			'section'     => 'expert_gamer_slider_setting',
			'settings'    => 'expert_gamer_slider_setting',
			'type'        => 'checkbox'
		) 
	);

	// Slider Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_slider_button_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_slider_button_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Button', 'expert-gamer' ),
			'section'     => 'expert_gamer_slider_setting',
			'settings'    => 'expert_gamer_slider_button_setting',
			'type'        => 'checkbox'
		) 
	);

    $wp_customize->add_setting(
    	'expert_gamer_slider_top_content',
    	array(
	        'default'   => '',
	        'sanitize_callback' => 'sanitize_text_field'
    	)
    );
    $wp_customize->add_control(
    	'expert_gamer_slider_top_content',
    	array(
	        'label' => __('Short Heading','expert-gamer'),
	        'section'   => 'expert_gamer_slider_setting',
	        'type'      => 'text'
    	)
    );
	
	// Slider 1
	$wp_customize->add_setting( 
    	'expert_gamer_slider1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'expert_gamer_slider1',
		array(
		    'label'   		=> __('Slider 1','expert-gamer'),
		    'section'		=> 'expert_gamer_slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		

	// Slider 2
	$wp_customize->add_setting(
    	'expert_gamer_slider2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'expert_gamer_slider2',
		array(
		    'label'   		=> __('Slider 2','expert-gamer'),
		    'section'		=> 'expert_gamer_slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 3
	$wp_customize->add_setting(
    	'expert_gamer_slider3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'expert_gamer_slider3',
		array(
		    'label'   		=> __('Slider 3','expert-gamer'),
		    'section'		=> 'expert_gamer_slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	

	/*=========================================
	Latest Release Section
	=========================================*/

	$wp_customize->add_section(
		'expert_gamer_latest_release_section', array(
			'title' => esc_html__( 'Latest Release Section', 'expert-gamer' ),
			'priority' => 13,
			'panel' => 'expert_gamer_frontpage_sections',
		)
	);

	// Latest Release Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_latest_release_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_latest_release_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'expert-gamer' ),
			'section'     => 'expert_gamer_latest_release_section',
			'settings'    => 'expert_gamer_latest_release_setting',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting(
		'expert_gamer_latest_release_heading',
		array(
			'default' => '',
			'sanitize_callback'	=> 'sanitize_text_field'
		)
	);

	$wp_customize->add_control(
		'expert_gamer_latest_release_heading',
		array(
			'label'	=> __('Section Title','expert-gamer'),
			'section'	=> 'expert_gamer_latest_release_section',
			'type'		=> 'text'
		)
	);

	$wp_customize->add_setting(
		'expert_gamer_latest_release_sub_heading',
		array(
			'default' => '',
			'sanitize_callback'	=> 'sanitize_text_field'
		)
	);

	$wp_customize->add_control(
		'expert_gamer_latest_release_sub_heading',
		array(
			'label'	=> __('Section Sub Title','expert-gamer'),
			'section'	=> 'expert_gamer_latest_release_section',
			'type'		=> 'text'
		)
	);

	$expert_gamer_categories = get_categories();
	$cats = array();
	$i = 0;
	$expert_gamer_offer_cat[]= 'select';
	foreach($expert_gamer_categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$expert_gamer_offer_cat[$category->slug] = $category->name;
	}

	$wp_customize->add_setting(
		'expert_gamer_latest_release_section_category',
		array(
			'default'	=> 'select',
			'sanitize_callback' => 'expert_gamer_sanitize_choices',
		)
	);

	$wp_customize->add_control(
		'expert_gamer_latest_release_section_category',
		array(
			'type'    => 'select',
			'choices' => $expert_gamer_offer_cat,
			'label' => __('Select Category','expert-gamer'),
			'section' => 'expert_gamer_latest_release_section',
		)
	);
}

add_action( 'customize_register', 'expert_gamer_blog_setting' );

// service selective refresh
function expert_gamer_blog_section_partials( $wp_customize ){	
	// blog_title
	$wp_customize->selective_refresh->add_partial( 'blog_title', array(
		'selector'            => '.home-blog .title h6',
		'settings'            => 'blog_title',
		'render_callback'  => 'expert_gamer_blog_title_render_callback',
	
	) );
	
	// blog_subtitle
	$wp_customize->selective_refresh->add_partial( 'blog_subtitle', array(
		'selector'            => '.home-blog .title h2',
		'settings'            => 'blog_subtitle',
		'render_callback'  => 'expert_gamer_blog_subtitle_render_callback',
	
	) );
	
	// blog_description
	$wp_customize->selective_refresh->add_partial( 'blog_description', array(
		'selector'            => '.home-blog .title p',
		'settings'            => 'blog_description',
		'render_callback'  => 'expert_gamer_blog_description_render_callback',
	
	) );	
	}

add_action( 'customize_register', 'expert_gamer_blog_section_partials' );

// blog_title
function expert_gamer_blog_title_render_callback() {
	return get_theme_mod( 'blog_title' );
}

// blog_subtitle
function expert_gamer_blog_subtitle_render_callback() {
	return get_theme_mod( 'blog_subtitle' );
}

// service description
function expert_gamer_blog_description_render_callback() {
	return get_theme_mod( 'blog_description' );
}