<?php
function expert_gamer_header_settings( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';

    // Site Title Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_site_title_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_site_title_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Site Title', 'expert-gamer' ),
			'section'     => 'title_tagline',
			'settings'    => 'expert_gamer_site_title_setting',
			'type'        => 'checkbox'
		) 
	);

	// Tagline Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_gamer_tagline_setting' , 
			array(
			'default' => '',
			'sanitize_callback' => 'expert_gamer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_gamer_tagline_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Tagline', 'expert-gamer' ),
			'section'     => 'title_tagline',
			'settings'    => 'expert_gamer_tagline_setting',
			'type'        => 'checkbox'
		) 
	);

	/*=========================================
	Header Settings Panel
	=========================================*/
	$wp_customize->add_panel( 
		'expert_gamer_header_section', 
		array(
			'priority'      => 2,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Header', 'expert-gamer'),
		) 
	);

	/*=========================================
	Expert Gamer Site Identity
	=========================================*/
	$wp_customize->add_section(
        'expert_gamer_title_tagline',
        array(
        	'priority'      => 1,
            'title' 		=> __('Site Identity','expert-gamer'),
			'panel'  		=> 'expert_gamer_header_section',
		)
    );    

	/*=========================================
	Top header
	=========================================*/
	$wp_customize->add_section(
        'expert_gamer_top_header',
        array(
        	'priority'      => 2,
            'title' 		=> __('Header','expert-gamer'),
			'panel'  		=> 'expert_gamer_header_section',
		)
    );

	// general setting

	$wp_customize->add_setting(
    	'expert_gamer_topheader_phone_number',
    	array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);	
	$wp_customize->add_control( 
		'expert_gamer_topheader_phone_number',
		array(
		    'label'   		=> __('Phone Number','expert-gamer'),
		    'section'		=> 'expert_gamer_top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_gamer_topheader_book_btn_text',
    	array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);	
	$wp_customize->add_control( 
		'expert_gamer_topheader_book_btn_text',
		array(
		    'label'   		=> __('Header Button Text','expert-gamer'),
		    'section'		=> 'expert_gamer_top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_gamer_topheader_book_btn_link',
    	array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);	
	$wp_customize->add_control( 
		'expert_gamer_topheader_book_btn_link',
		array(
		    'label'   		=> __('Header Button Link','expert-gamer'),
		    'section'		=> 'expert_gamer_top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	/*=========================================
	Social Media
	=========================================*/
	$wp_customize->add_section(
        'expert_gamer_social_media_url',
        array(
            'title' 		=> __('Social Media','expert-gamer'),
			'panel'  		=> 'expert_gamer_header_section',
		)
    );

	$wp_customize->add_setting(
    	'expert_gamer_topheader_pintrest',
    	array(
			'default' => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);	
	$wp_customize->add_control( 
		'expert_gamer_topheader_pintrest',
		array(
		    'label'   		=> __('Pintrest url','expert-gamer'),
		    'section'		=> 'expert_gamer_social_media_url',
			'type' 			=> 'url',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_gamer_topheader_facebook',
    	array(
			'default' => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);	
	$wp_customize->add_control( 
		'topheader_facebook',
		array(
		    'label'   		=> __('Facebook url','expert-gamer'),
		    'section'		=> 'expert_gamer_social_media_url',
			'type' 			=> 'url',
			'transport'         => $selective_refresh,
		)
	);

	$wp_customize->add_setting(
    	'expert_gamer_topheader_twitter',
    	array(
			'default' => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);	
	$wp_customize->add_control( 
		'topheader_twitter',
		array(
		    'label'   		=> __('Twitter url','expert-gamer'),
		    'section'		=> 'expert_gamer_social_media_url',
			'type' 			=> 'url',
			'transport'         => $selective_refresh,
		)
	);

	$wp_customize->add_setting(
    	'expert_gamer_topheader_linkdin',
    	array(
			'default' => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);	
	$wp_customize->add_control( 
		'expert_gamer_topheader_linkdin',
		array(
		    'label'   		=> __('Linkdin url','expert-gamer'),
		    'section'		=> 'expert_gamer_social_media_url',
			'type' 			=> 'url',
			'transport'         => $selective_refresh,
		)
	);

	$wp_customize->register_panel_type( 'Expert_Gamer_WP_Customize_Panel' );
	$wp_customize->register_section_type( 'Expert_Gamer_WP_Customize_Section' );

}
add_action( 'customize_register', 'expert_gamer_header_settings' );


if ( class_exists( 'WP_Customize_Panel' ) ) {
  	class Expert_Gamer_WP_Customize_Panel extends WP_Customize_Panel {
	   public $panel;
	   public $type = 'expert_gamer_panel';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;
	      return $array;
    	}
  	}
}

if ( class_exists( 'WP_Customize_Section' ) ) {
  	class Expert_Gamer_WP_Customize_Section extends WP_Customize_Section {
	   public $section;
	   public $type = 'expert_gamer_section';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;

	      if ( $this->panel ) {
	        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
	      } else {
	        $array['customizeAction'] = 'Customizing';
	      }
	      return $array;
    	}
  	}
}