<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Expert Gamer
 */

if ( ! function_exists( 'expert_gamer_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 */
function expert_gamer_posted_on() {
	$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
	}

	$time_string = sprintf( $time_string,
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_attr( get_the_modified_date( 'c' ) ),
		esc_html( get_the_modified_date() )
	);

	$posted_on = sprintf(
		esc_html_x( 'Posted on %s', 'post date', 'expert-gamer' ),
		'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
	);

	$byline = sprintf(
		esc_html_x( 'by %s', 'post author', 'expert-gamer' ),
		'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
	);
	echo '<span class="posted-on">' . $posted_on . '</span><span class="byline"> ' . $byline . '</span>'; // WPCS: XSS OK.
}
endif;


if ( ! function_exists( 'expert_gamer_entry_footer' ) ) :
/**
 * Prints HTML with meta information for the categories, tags and comments.
 */
function expert_gamer_entry_footer() {
	// Hide category and tag text for pages.
	if ( 'post' === get_post_type() ) {
		/* translators: used between list items, there is a space after the comma */
		$categories_list = get_the_category_list( esc_html__( ', ', 'expert-gamer' ) );
		if ( $categories_list && expert_gamer_categorized_blog() ) {
			printf( '<span class="cat-links">' . esc_html__( 'Posted in %1$s', 'expert-gamer' ) . '</span>', $categories_list ); // WPCS: XSS OK.
		}

		/* translators: used between list items, there is a space after the comma */
		$tags_list = get_the_tag_list( '', esc_html__( ', ', 'expert-gamer' ) );
		if ( $tags_list ) {
			printf( '<span class="tags-links">' . esc_html__( 'Tagged %1$s', 'expert-gamer' ) . '</span>', $tags_list ); // WPCS: XSS OK.
		}
	}

	if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
		echo '<span class="comments-link">';
		/* translators: %s: post title */
		comments_popup_link( sprintf( wp_kses( __( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'expert-gamer' ), array( 'span' => array( 'class' => array() ) ) ), get_the_title() ) );
		echo '</span>';
	}

	edit_post_link(
		sprintf(
			/* translators: %s: Name of current post */
			esc_html__( 'Edit %s', 'expert-gamer' ),
			the_title( '<span class="screen-reader-text">"', '"</span>', false )
		),
		'<span class="edit-link">',
		'</span>'
	);
}
endif;

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function expert_gamer_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'expert_gamer_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'expert_gamer_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 1 ) {
		// This blog has more than 1 category so expert_gamer_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so expert_gamer_categorized_blog should return false.
		return false;
	}
}

/**
 * Flush out the transients used in expert_gamer_categorized_blog.
 */
function expert_gamer_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'expert_gamer_categories' );
}
add_action( 'edit_category', 'expert_gamer_category_transient_flusher' );
add_action( 'save_post',     'expert_gamer_category_transient_flusher' );

/**
 * Register Google fonts.
 */
function expert_gamer_google_font() {
	$font_url      = '';
	$font_family   = array(
		'Bebas Neue',
		'Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900'
	);

	$fonts_url = add_query_arg( array(
		'family' => implode( '&family=', $font_family ),
		'display' => 'swap',
	), 'https://fonts.googleapis.com/css2' );

	$contents = wptt_get_webfont_url( esc_url_raw( $fonts_url ) );
	return $contents;
}

function expert_gamer_scripts_styles() {
    wp_enqueue_style( 'expert-gamer-fonts', expert_gamer_google_font(), array(), null );
}
add_action( 'wp_enqueue_scripts', 'expert_gamer_scripts_styles' );

/**
 * Register Breadcrumb for Multiple Variation
 */
function expert_gamer_breadcrumbs_style() {
	get_template_part('./template-parts/sections/section','breadcrumb');
}

/**
 * This Function Check whether Sidebar active or Not
 */
if(!function_exists( 'expert_gamer_post_layout' )) :
function expert_gamer_post_layout(){
	if(is_active_sidebar('expert-gamer-sidebar-primary'))
		{ echo 'col-lg-8'; } 
	else 
		{ echo 'col-lg-12'; }  
} endif;


// offer Meta
function expert_gamer_bn_custom_meta_offer() {
    add_meta_box( 'bn_meta', __( 'Trip Offer Meta Feilds', 'expert-gamer' ), 'expert_gamer_meta_callback_trip_offer', 'post', 'normal', 'high' );
}
/* Hook things in for admin*/
if (is_admin()){
  add_action('admin_menu', 'expert_gamer_bn_custom_meta_offer');
}

function expert_gamer_meta_callback_trip_offer( $post ) {
    wp_nonce_field( basename( __FILE__ ), 'expert_gamer_offer_trip_meta_nonce' );
    $expert_gamer_bn_stored_meta = get_post_meta( $post->ID );
    $expert_gamer_trip_amount = get_post_meta( $post->ID, 'expert_gamer_trip_amount', true );
    $expert_gamer_trip_days = get_post_meta( $post->ID, 'expert_gamer_trip_days', true );
    ?>
    <div id="testimonials_custom_stuff">
        <table id="list">
            <tbody id="the-list" data-wp-lists="list:meta">
                <tr id="meta-8">
                    <td class="left">
                        <?php esc_html_e( 'Package Amount', 'expert-gamer' )?>
                    </td>
                    <td class="left">
                        <input type="text" name="expert_gamer_trip_amount" id="expert_gamer_trip_amount" value="<?php echo esc_attr($expert_gamer_trip_amount); ?>" />
                    </td>
                </tr>
                <tr id="meta-8">
                    <td class="left">
                        <?php esc_html_e( 'Package Days', 'expert-gamer' )?>
                    </td>
                    <td class="left">
                        <input type="text" name="expert_gamer_trip_days" id="expert_gamer_trip_days" value="<?php echo esc_attr($expert_gamer_trip_days); ?>" />
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <?php
}

/* Saves the custom meta input */
function expert_gamer_bn_metadesig_save( $post_id ) {
    if (!isset($_POST['expert_gamer_offer_trip_meta_nonce']) || !wp_verify_nonce( strip_tags( wp_unslash( $_POST['expert_gamer_offer_trip_meta_nonce']) ), basename(__FILE__))) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    // Save Trip Amount
    if( isset( $_POST[ 'expert_gamer_trip_amount' ] ) ) {
        update_post_meta( $post_id, 'expert_gamer_trip_amount', strip_tags( wp_unslash( $_POST[ 'expert_gamer_trip_amount' ]) ) );
    }
    // Save Trip Days
    if( isset( $_POST[ 'expert_gamer_trip_days' ] ) ) {
        update_post_meta( $post_id, 'expert_gamer_trip_days', strip_tags( wp_unslash( $_POST[ 'expert_gamer_trip_days' ]) ) );
    }
}
add_action( 'save_post', 'expert_gamer_bn_metadesig_save' );