<div class="awpr-widgets-wrapper">
    <?php if ( !AWR_IS_PRO_VERSION ) { 
    
        // Next is called in the js.config file
        // For each page loading, we move to the next banner via "get_next_banner" called in js.config.inc.php
        $banner_infos = awr\services\CommonService::get_instance()->get_current_banner_infos ();
        
        if ( is_array($banner_infos) ) {
            $banner_link = $banner_infos['link']; 
            $banner_img = $banner_infos['img']; 
            ?>

            <!-- Banner -->
            <div class="mb-5">
                <a href="<?php echo $banner_link; ?>" class="block" target="_blank">
                    <img src="<?php echo $banner_img; ?>" alt="banner" class="w-full h-full block rounded-[5px]">
                </a>
            </div>
            <?php 
        }
    } ?>
    <div class="awpr-widget mb-5">
        <h3 class="awpr-widget-title">
            <span class="icon-support"></span>
            Support
        </h3>
        <div class="mt-4">
            <p class="awpr-widget-text mb-6">Our support team is here for you, reach out if you require assistance</p>
            <div class="flex flex-col gap-2">
                <a href="<?php echo AWR_PLUGIN_SUPPORT; ?>" target="_blank" class="flex items-center awpr-link">
                    <!--span class="icon-contact-support"></span-->
                    <svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4 h-4">
                        <path d="M5.89185 12.4365V10.542C3.25536 10.4052 1.15564 8.21597 1.15564 5.54791C1.15564 2.79039 3.39744 0.548584 6.15497 0.548584C8.91249 0.548584 11.1543 2.79039 11.1543 5.54791C11.1543 8.15283 9.34401 10.7735 6.64438 12.0734L5.89185 12.4365ZM6.15497 1.60107C3.97631 1.60107 2.20813 3.36926 2.20813 5.54791C2.20813 7.72657 3.97631 9.49475 6.15497 9.49475H6.94434V10.7051C8.85987 9.49475 10.1018 7.50554 10.1018 5.54791C10.1018 3.36926 8.33362 1.60107 6.15497 1.60107ZM5.62872 7.65289H6.68121V8.70538H5.62872V7.65289ZM6.68121 6.86353H5.62872C5.62872 5.15323 7.20746 5.28479 7.20746 4.2323C7.20746 3.65343 6.73384 3.17981 6.15497 3.17981C5.5761 3.17981 5.10248 3.65343 5.10248 4.2323H4.04999C4.04999 3.0693 4.99197 2.12732 6.15497 2.12732C7.31797 2.12732 8.25995 3.0693 8.25995 4.2323C8.25995 5.54791 6.68121 5.67947 6.68121 6.86353Z" fill="#9B3490"/>
                    </svg>
                    <span style="margin-left: 10px;">Contact Support</span>
                </a>
                <a href="<?php echo AWR_PLUGIN_SUPPORT; ?>" target="_blank" class="flex items-center awpr-link">
                    <!--span class="icon-bug"></span-->
                    <svg width="14" height="15" viewBox="0 0 15 16" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4 h-4">
                        <path d="M2.92517 9.68445C2.92517 11.8691 4.69211 13.6361 6.87679 13.6361C9.06147 13.6361 10.8284 11.8691 10.8284 9.68445V7.42638H2.92517V9.68445ZM9.20259 3.11912L10.3881 1.93364L9.92518 1.46509L8.62679 2.76912C8.09614 2.5038 7.50904 2.34573 6.87679 2.34573C6.24453 2.34573 5.65743 2.5038 5.13243 2.76912L3.8284 1.46509L3.36549 1.93364L4.55098 3.11912C3.56872 3.83606 2.92517 4.98767 2.92517 6.29735V6.86187H10.8284V6.29735C10.8284 4.98767 10.1849 3.83606 9.20259 3.11912ZM5.18324 5.73283C4.87275 5.73283 4.61872 5.4788 4.61872 5.16832C4.61872 4.85783 4.87275 4.6038 5.18324 4.6038C5.49372 4.6038 5.74775 4.85783 5.74775 5.16832C5.74775 5.4788 5.49372 5.73283 5.18324 5.73283ZM8.57034 5.73283C8.25985 5.73283 8.00582 5.4788 8.00582 5.16832C8.00582 4.85783 8.25985 4.6038 8.57034 4.6038C8.88082 4.6038 9.13485 4.85783 9.13485 5.16832C9.13485 5.4788 8.88082 5.73283 8.57034 5.73283Z" fill="#9B3490"/>
                    </svg>
                    <span style="margin-left: 10px;">Report a bug</span>
                </a>
                <a href="#" target="_blank" class="flex items-center awpr-link" id="awr-get-system-infos">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 15 13" class="w-4 h-4">
                        <path fill="currentColor" d="M7.88 2.518a.749.749 0 0 0-.005-1.045.758.758 0 0 0-1.061-.002.741.741 0 0 0-.004 1.049.734.734 0 0 0 1.07-.002Zm-.713-.693a.247.247 0 1 1 .347.352.226.226 0 0 1-.343-.002.239.239 0 0 1-.004-.35Zm.927 3.944V3.528a.466.466 0 0 0-.284-.423c-.377-.234-1.247-.07-1.216.423v2.24c.003.707 1.49.696 1.5 0Zm-1-2.217a.61.61 0 0 1 .5.005v2.174a.488.488 0 0 1-.5.005V3.552Zm7.44 7.495a.743.743 0 0 0-.44-.278V3.501a.75.75 0 0 0-.75-.75h-2.398a3.7 3.7 0 0 0-7.153 0h-2.45a.75.75 0 0 0-.75.75v7.268a.746.746 0 0 0-.566.932l.07.25a.752.752 0 0 0 .722.55h13.049a.752.752 0 0 0 .723-.55l.069-.25a.744.744 0 0 0-.126-.654ZM3.712 4.25a3.68 3.68 0 0 0 .616 1.555l-.48 1.318a.5.5 0 0 0 .667.63l1.456-.623a3.697 3.697 0 0 0 5.061-2.88h1.562v5.5h-10.5v-5.5h1.618Zm.496-1.056A3.204 3.204 0 1 1 10.04 5.48a3.2 3.2 0 0 1-3.966 1.15.249.249 0 0 0-.2 0l-1.555.665.52-1.427a.278.278 0 0 0-.035-.256 3.195 3.195 0 0 1-.595-2.417ZM1.094 3.5a.25.25 0 0 1 .25-.25H3.7a3.78 3.78 0 0 0-.028.5H2.094a.5.5 0 0 0-.5.5v5.5a.5.5 0 0 0 .5.5h10.5a.5.5 0 0 0 .5-.5v-5.5a.501.501 0 0 0-.5-.5h-1.521a3.747 3.747 0 0 0-.028-.5h2.299a.25.25 0 0 1 .25.25v7.25H9.3a.744.744 0 0 0-.53.22l-.208.207a.252.252 0 0 1-.176.073H6.3a.252.252 0 0 1-.177-.073l-.207-.207a.748.748 0 0 0-.53-.22H1.094V3.5Zm13.084 8.067-.07.25a.25.25 0 0 1-.24.183H.819a.25.25 0 0 1-.24-.183l-.07-.25a.25.25 0 0 1 .241-.317h4.637a.25.25 0 0 1 .176.073l.207.207a.744.744 0 0 0 .53.22h2.087a.746.746 0 0 0 .53-.22l.207-.207a.252.252 0 0 1 .177-.073h4.636a.25.25 0 0 1 .24.317Z"/>
                    </svg>&nbsp;
                    <span style="margin-left: 7px;">System infos</span>
                </a>
                <!--a href="#" target="_blank" class="awpr-button-brand border border-awpr-brand inline-flex items-center px-3 py-1 gap-3 text-[13px] text-awpr-brand hover:bg-awpr-brand hover:border-awpr-brand hover:text-white transition-all duration-200 ease-in-out">
                    <span class="icon-emergency"></span>
                    <span class="awpr-icon-separator">|</span>
                    emergency
                </a-->
            </div>
        </div>

        <h3 class="awpr-widget-title mt-6">
            <span class="icon-support"></span>
            Useful links
        </h3>
        <div class="mt-4">
            <div class="flex gap-2">
                <a href="<?php echo AWR_YOUTUBE_CHANNEL; ?>" target="_blank" class="flex items-center mr-2" style="color:#343434;  font-size: 12px;">
                    <svg width="19" height="14" viewBox="0 0 19 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M14.3645 0.83313H3.84127C1.77663 0.83313 0.102905 2.50685 0.102905 4.5715V9.83202C0.102905 11.8967 1.77663 13.5704 3.84127 13.5704H14.3645C16.4292 13.5704 18.1029 11.8967 18.1029 9.83202V4.5715C18.1029 2.50685 16.4292 0.83313 14.3645 0.83313ZM11.8363 7.4577L6.91423 9.80523C6.78308 9.86778 6.63158 9.77216 6.63158 9.62687V4.78508C6.63158 4.63772 6.78706 4.54222 6.91849 4.60883L11.8406 7.10309C11.9869 7.17724 11.9844 7.38711 11.8363 7.4577Z" fill="#F61C0D"/>
                    </svg> &nbsp;Watch demo
                </a>
                <a href="<?php echo AWR_PLUGIN_FAQ; ?>" target="_blank" class="flex items-center" style="margin-left: 40px;color:#343434;  font-size: 12px;">
                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M9.94666 3.98303H1.50916C1.13654 3.98415 0.779498 4.13266 0.516016 4.39614C0.252534 4.65962 0.104018 5.01666 0.102905 5.38928L0.102905 12.4205C0.103707 12.7112 0.194165 12.9946 0.361942 13.232C0.529719 13.4694 0.766645 13.6493 1.04041 13.7471V15.233C1.04088 15.3213 1.06618 15.4077 1.11343 15.4823C1.16068 15.5569 1.22796 15.6167 1.30759 15.6549C1.36989 15.6869 1.43913 15.703 1.50916 15.7018C1.61515 15.7027 1.71805 15.6662 1.79978 15.5987L4.01697 13.8268H9.94666C10.3193 13.8257 10.6763 13.6772 10.9398 13.4137C11.2033 13.1502 11.3518 12.7932 11.3529 12.4205V5.38928C11.3518 5.01666 11.2033 4.65962 10.9398 4.39614C10.6763 4.13266 10.3193 3.98415 9.94666 3.98303ZM5.72791 11.9518C5.6352 11.9518 5.54457 11.9243 5.46748 11.8728C5.3904 11.8213 5.33032 11.7481 5.29484 11.6624C5.25936 11.5768 5.25008 11.4825 5.26816 11.3916C5.28625 11.3007 5.33089 11.2171 5.39645 11.1516C5.46201 11.086 5.54553 11.0414 5.63646 11.0233C5.72739 11.0052 5.82164 11.0145 5.90729 11.05C5.99294 11.0854 6.06615 11.1455 6.11766 11.2226C6.16916 11.2997 6.19666 11.3903 6.19666 11.483C6.19628 11.6072 6.14678 11.7263 6.05895 11.8141C5.97112 11.9019 5.85211 11.9514 5.72791 11.9518ZM6.59978 9.23303C6.46976 9.30644 6.36115 9.41251 6.2847 9.54076C6.20824 9.66901 6.16658 9.815 6.16384 9.96428V10.0112C6.16384 10.1355 6.11446 10.2547 6.02655 10.3426C5.93864 10.4305 5.81941 10.4799 5.69509 10.4799C5.57077 10.4799 5.45154 10.4305 5.36364 10.3426C5.27573 10.2547 5.22634 10.1355 5.22634 10.0112V9.96428C5.22822 9.65038 5.31284 9.34251 5.47168 9.07175C5.63051 8.80099 5.85794 8.5769 6.13103 8.42209C6.24726 8.35578 6.34667 8.26359 6.42155 8.15268C6.49643 8.04177 6.54477 7.91512 6.56284 7.78252C6.5809 7.64993 6.5682 7.51495 6.52572 7.38806C6.48325 7.26116 6.41213 7.14574 6.31787 7.05074C6.22362 6.95575 6.10877 6.88372 5.98221 6.84024C5.85565 6.79677 5.72078 6.783 5.58805 6.80003C5.45531 6.81705 5.32828 6.86439 5.21678 6.9384C5.10529 7.0124 5.01232 7.11108 4.94509 7.22678C4.91188 7.28296 4.88515 7.34271 4.86541 7.40491C4.82811 7.52363 4.74518 7.62268 4.63485 7.68026C4.52453 7.73784 4.39585 7.74923 4.27712 7.71194C4.1584 7.67464 4.05935 7.59171 4.00177 7.48139C3.94419 7.37106 3.9328 7.24238 3.97009 7.12366C4.01226 6.99654 4.06723 6.87404 4.13416 6.75803C4.33019 6.42269 4.62846 6.15893 4.98527 6.00541C5.34208 5.85189 5.73868 5.81667 6.11697 5.90491C6.44334 5.98086 6.74191 6.1467 6.97886 6.38364C7.2158 6.62059 7.38164 6.91916 7.45759 7.24553C7.54704 7.62501 7.51191 8.0232 7.35742 8.38116C7.20292 8.73912 6.93727 9.03782 6.59978 9.23303Z" fill="#9B3490"/>
                    </svg> 
                    FAQ
                </a>
            </div>
        </div>
    </div>
</div>