<?php

if ( function_exists( 'acf_add_local_field_group' ) ) {
    acf_add_local_field_group( array(
        'key'                   => 'group_5f8c0ce69ac12',
        'title'                 => esc_html__( 'Category Header Settings', 'caeliora' ),
        'fields'                => array(
        array(
        'key'               => 'field_5f8c0cf8ee464_select',
        'label'             => esc_html__( 'Category Header Background Type', 'caeliora' ),
        'name'              => 'caeliora_acf_category_type',
        'type'              => 'button_group',
        'instructions'      => esc_html__( 'Set default via <strong>Appearance > Customize > Colors & Typography > Category/Archive</strong>', 'caeliora' ),
        'required'          => 0,
        'conditional_logic' => 0,
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'choices'           => array(
        'default' => 'Default',
        'color'   => 'Color',
        'image'   => 'Image',
    ),
        'allow_null'        => 0,
        'default_value'     => 'default',
        'layout'            => 'horizontal',
        'return_format'     => 'value',
    ),
        array(
        'key'               => 'field_5f8c145993ad7_bg_color',
        'label'             => esc_html__( 'Background Color', 'caeliora' ),
        'name'              => 'caeliora_acf_category_bg_color',
        'type'              => 'color_picker',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5f8c0cf8ee464_select',
        'operator' => '==',
        'value'    => 'color',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'default_value'     => '#f7f7f7',
    ),
        array(
        'key'               => 'field_5f8c145993ad7_bg_border',
        'label'             => esc_html__( 'Background Border Color', 'caeliora' ),
        'name'              => 'caeliora_acf_category_bg_border',
        'type'              => 'color_picker',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5f8c0cf8ee464_select',
        'operator' => '==',
        'value'    => 'color',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'default_value'     => '#eaeaea',
    ),
        array(
        'key'               => 'field_5f8c0cf8ee464',
        'label'             => esc_html__( 'Background Image', 'caeliora' ),
        'name'              => 'caeliora_acf_category_img',
        'type'              => 'image',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5f8c0cf8ee464_select',
        'operator' => '==',
        'value'    => 'image',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'return_format'     => 'url',
        'preview_size'      => 'medium',
        'library'           => 'all',
        'min_width'         => '',
        'min_height'        => '',
        'min_size'          => '',
        'max_width'         => '',
        'max_height'        => '',
        'max_size'          => '',
        'mime_types'        => '',
    ),
        array(
        'key'               => 'field_5f8c145993ad7',
        'label'             => esc_html__( 'Background Image Overlay Color', 'caeliora' ),
        'name'              => 'caeliora_acf_category_img_overlay',
        'type'              => 'color_picker',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5f8c0cf8ee464_select',
        'operator' => '==',
        'value'    => 'image',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'default_value'     => '#000000',
    ),
        array(
        'key'               => 'field_5f8c148e93ad8',
        'label'             => esc_html__( 'Background Image Overlay Color Transparency', 'caeliora' ),
        'name'              => 'caeliora_acf_category_img_overlay_trans',
        'type'              => 'range',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5f8c0cf8ee464_select',
        'operator' => '==',
        'value'    => 'image',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'default_value'     => '0',
        'min'               => '',
        'max'               => 1,
        'step'              => '0.01',
        'prepend'           => '',
        'append'            => '',
    ),
        array(
        'key'               => 'field_5f8c0e77095fc',
        'label'             => esc_html__( 'Background Repeat', 'caeliora' ),
        'name'              => 'caeliora_acf_category_img_repeat',
        'type'              => 'button_group',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5f8c0cf8ee464_select',
        'operator' => '==',
        'value'    => 'image',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'choices'           => array(
        'no-repeat' => 'No Repeat',
        'repeat'    => 'Repeat',
    ),
        'allow_null'        => 0,
        'default_value'     => 'no-repeat',
        'layout'            => 'horizontal',
        'return_format'     => 'value',
    ),
        array(
        'key'               => 'field_5f8c0edf095fd',
        'label'             => esc_html__( 'Background Posiiton', 'caeliora' ),
        'name'              => 'caeliora_acf_category_img_position',
        'type'              => 'select',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5f8c0cf8ee464_select',
        'operator' => '==',
        'value'    => 'image',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'choices'           => array(
        'left top'      => 'Left Top',
        'left center'   => 'Left Center',
        'left bottom'   => 'Left Bottom',
        'right top'     => 'Right Top',
        'right center'  => 'Right Center',
        'right bottom'  => 'Right Bottom',
        'center top'    => 'Center Top',
        'center center' => 'Center Center',
        'center bottom' => 'Center Bottom',
    ),
        'default_value'     => array(
        0 => 'center center',
    ),
        'allow_null'        => 0,
        'multiple'          => 0,
        'ui'                => 0,
        'return_format'     => 'value',
        'ajax'              => 0,
        'placeholder'       => '',
    ),
        array(
        'key'               => 'field_5f8c0f90095fe',
        'label'             => esc_html__( 'Background Size', 'caeliora' ),
        'name'              => 'caeliora_acf_category_img_size',
        'type'              => 'button_group',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5f8c0cf8ee464_select',
        'operator' => '==',
        'value'    => 'image',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'choices'           => array(
        'cover'   => 'Cover',
        'contain' => 'Contain',
        'auto'    => 'Auto',
    ),
        'allow_null'        => 0,
        'default_value'     => 'cover',
        'layout'            => 'horizontal',
        'return_format'     => 'value',
    ),
        array(
        'key'               => 'field_5f8c0f90095fe_extend',
        'label'             => esc_html__( 'Extend Category Header Over Header Bar', 'caeliora' ),
        'name'              => 'caeliora_acf_category_header_extend',
        'type'              => 'button_group',
        'instructions'      => 'Set default via <strong>Appearance > Customize > Category/Archive Settings</strong><br>Note: Only works with Header Layout 1 and 2',
        'required'          => 0,
        'conditional_logic' => 0,
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'choices'           => array(
        'default' => 'Default',
        'yes'     => 'Yes',
        'no'      => 'No',
    ),
        'allow_null'        => 0,
        'default_value'     => 'default',
        'layout'            => 'horizontal',
        'return_format'     => 'value',
    ),
        array(
        'key'               => 'field_5f8c0f90095fe_textt',
        'label'             => esc_html__( 'Text Colors', 'caeliora' ),
        'name'              => 'caeliora_acf_category_text_colors',
        'type'              => 'button_group',
        'instructions'      => 'Set default via <strong>Appearance > Customize > Colors & Typography > Category/Archive</strong>',
        'required'          => 0,
        'conditional_logic' => 0,
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'choices'           => array(
        'default' => 'Default',
        'custom'  => 'Custom',
    ),
        'allow_null'        => 0,
        'default_value'     => 'default',
        'layout'            => 'horizontal',
        'return_format'     => 'value',
    ),
        array(
        'key'               => 'field_5f8c0f90095fe_textt_title',
        'label'             => esc_html__( 'Title Color', 'caeliora' ),
        'name'              => 'caeliora_acf_category_text_title',
        'type'              => 'color_picker',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5f8c0f90095fe_textt',
        'operator' => '==',
        'value'    => 'custom',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'default_value'     => '#000000',
    ),
        array(
        'key'               => 'field_5f8c0f90095fe_textt_browsing',
        'label'             => esc_html__( '"Browsing" Text Color', 'caeliora' ),
        'name'              => 'caeliora_acf_category_text_browsing',
        'type'              => 'color_picker',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5f8c0f90095fe_textt',
        'operator' => '==',
        'value'    => 'custom',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'default_value'     => '#888888',
    ),
        array(
        'key'               => 'field_5f8c0f90095fe_height',
        'label'             => esc_html__( 'Background Height', 'caeliora' ),
        'name'              => 'caeliora_acf_category_height',
        'type'              => 'button_group',
        'instructions'      => 'Default height is set via <strong>Appearance > Customize > Category/Archive Settings</strong>',
        'required'          => 0,
        'conditional_logic' => 0,
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'choices'           => array(
        'default' => 'Default',
        'custom'  => 'Custom',
    ),
        'allow_null'        => 0,
        'default_value'     => 'default',
        'layout'            => 'horizontal',
        'return_format'     => 'value',
    ),
        array(
        'key'               => 'field_5f8c0f90095fe_height_custom',
        'label'             => esc_html__( 'Custom Background Height', 'caeliora' ),
        'name'              => 'caeliora_acf_category_height_custom',
        'type'              => 'number',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5f8c0f90095fe_height',
        'operator' => '==',
        'value'    => 'custom',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'default_value'     => 160,
        'placeholder'       => '',
        'prepend'           => '',
        'append'            => '',
        'min'               => 0,
        'max'               => 2500,
        'step'              => 1,
    ),
        array(
        'key'               => 'field_5f8c0f90095fe_content_layout',
        'label'             => esc_html__( 'Category Content Layout', 'caeliora' ),
        'name'              => 'caeliora_acf_category_custom_content_layout',
        'type'              => 'button_group',
        'instructions'      => 'Set default Post Layout via <strong>Appearance > Customize > Category/Archive Settings</strong>',
        'required'          => 0,
        'conditional_logic' => 0,
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'choices'           => array(
        'default'              => 'Default',
        'isSidebar'            => 'Sidebar',
        'isFullwidth isNarrow' => 'Full-width',
    ),
        'allow_null'        => 0,
        'default_value'     => 'default',
        'layout'            => 'horizontal',
        'return_format'     => 'value',
    ),
        array(
        'key'               => 'field_5f8c0f90095fe_layout',
        'label'             => esc_html__( 'Category Post Layout', 'caeliora' ),
        'name'              => 'caeliora_acf_category_custom_layout',
        'type'              => 'button_group',
        'instructions'      => 'Set default Post Layout via <strong>Appearance > Customize > Category/Archive Settings</strong>',
        'required'          => 0,
        'conditional_logic' => 0,
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'choices'           => array(
        'default' => 'Default',
        'custom'  => 'Custom',
    ),
        'allow_null'        => 0,
        'default_value'     => 'default',
        'layout'            => 'horizontal',
        'return_format'     => 'value',
    ),
        array(
        'key'               => 'field_5c68f87_blog_layout',
        'label'             => esc_html__( 'Select Category Post Layout', 'caeliora' ),
        'name'              => 'caeliora_acf_category_blog_layout',
        'type'              => 'radio',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5f8c0f90095fe_layout',
        'operator' => '==',
        'value'    => 'custom',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => 'acf-image-select',
        'id'    => '',
    ),
        'choices'           => array(
        'classic'      => '<img src="' . get_template_directory_uri() . '/admin/admin-img/classic.png" />',
        'classic_grid' => '<img src="' . get_template_directory_uri() . '/admin/admin-img/classic-grid.png" />',
        'grid'         => '<img src="' . get_template_directory_uri() . '/admin/admin-img/grid.png" />',
        'classic_list' => '<img src="' . get_template_directory_uri() . '/admin/admin-img/classic-list.png" />',
        'list'         => '<img src="' . get_template_directory_uri() . '/admin/admin-img/list.png" />',
    ),
        'allow_null'        => 0,
        'other_choice'      => 0,
        'default_value'     => 'classic',
        'layout'            => 'horizontal',
        'return_format'     => 'value',
        'save_other_choice' => 0,
    ),
        array(
        'key'               => 'field_5c68f87_blog_grid',
        'label'             => esc_html__( 'Select Grid Style', 'caeliora' ),
        'name'              => 'caeliora_acf_category_blog_layout_grid',
        'type'              => 'radio',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5c68f87_blog_layout',
        'operator' => '==',
        'value'    => 'grid',
    ) ), array( array(
        'field'    => 'field_5c68f87_blog_layout',
        'operator' => '==',
        'value'    => 'classic_grid',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'choices'           => array(
        'style1' => esc_html__( 'Grid Style 1', 'caeliora' ),
        'style2' => esc_html__( 'Grid Style 2', 'caeliora' ),
        'style3' => esc_html__( 'Grid Style 3', 'caeliora' ),
    ),
        'allow_null'        => 0,
        'other_choice'      => 0,
        'default_value'     => 'style1',
        'layout'            => 'horizontal',
        'return_format'     => 'value',
        'save_other_choice' => 0,
    ),
        array(
        'key'               => 'field_5c68f87_blog_list',
        'label'             => esc_html__( 'Select List Style', 'caeliora' ),
        'name'              => 'caeliora_acf_category_blog_layout_list',
        'type'              => 'radio',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5c68f87_blog_layout',
        'operator' => '==',
        'value'    => 'list',
    ) ), array( array(
        'field'    => 'field_5c68f87_blog_layout',
        'operator' => '==',
        'value'    => 'classic_list',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'choices'           => array(
        'style1' => esc_html__( 'Style 1', 'caeliora' ),
        'style2' => esc_html__( 'Style 2', 'caeliora' ),
    ),
        'allow_null'        => 0,
        'other_choice'      => 0,
        'default_value'     => 'style1',
        'layout'            => 'horizontal',
        'return_format'     => 'value',
        'save_other_choice' => 0,
    ),
        array(
        'key'               => 'field_5c68f87_blog_list_alternate',
        'label'             => esc_html__( 'Alternate List Posts?', 'caeliora' ),
        'name'              => 'caeliora_acf_category_blog_layout_list_alternate',
        'type'              => 'true_false',
        'instructions'      => '',
        'required'          => 0,
        'conditional_logic' => array( array( array(
        'field'    => 'field_5c68f87_blog_layout',
        'operator' => '==',
        'value'    => 'classic_list',
    ) ), array( array(
        'field'    => 'field_5c68f87_blog_layout',
        'operator' => '==',
        'value'    => 'list',
    ) ) ),
        'wrapper'           => array(
        'width' => '',
        'class' => '',
        'id'    => '',
    ),
        'message'           => '',
        'default_value'     => 0,
        'ui'                => 1,
        'ui_on_text'        => '',
        'ui_off_text'       => '',
    )
    ),
        'location'              => array( array( array(
        'param'    => 'taxonomy',
        'operator' => '==',
        'value'    => 'category',
    ) ) ),
        'menu_order'            => 0,
        'position'              => 'normal',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => '',
        'active'                => true,
        'description'           => '',
    ) );
}