import { __ } from '@wordpress/i18n';
import { TourButton } from '@assist/components/buttons/TourButton';
import { useTourStore } from '@assist/state/Tours';

export const TourItem = ({ tour }) => {
	const { wasOpened } = useTourStore();
	const { slug } = tour;

	return (
		<>
			<div className="flex gap-3 items-center">
				<div className="sr-only">
					{wasOpened(slug)
						? __('Completed', 'extendify-local')
						: __('Not completed', 'extendify-local')}
				</div>
				<svg
					width="16"
					height="16"
					viewBox="0 0 16 16"
					aria-hidden="true"
					focusable="false"
					className="shrink-0 w-6 h-6 rounded-full text-gray-400">
					{/* <!-- The background --> */}
					<circle
						className="checkbox__background"
						r="5"
						cx="8"
						cy="8"
						stroke={
							wasOpened(slug)
								? 'var(--ext-design-main, #3959e9)'
								: 'currentColor'
						}
						fill={wasOpened(slug) ? 'var(--ext-design-main, #3959e9)' : 'none'}
						strokeWidth="1"
					/>
					{/* <!-- The checkmark--> */}
					<polyline
						className="checkbox__checkmark"
						points="5,8 8,10 11,6"
						stroke={wasOpened(slug) ? '#fff' : 'transparent'}
						strokeWidth="1"
						fill="none"
					/>
				</svg>
				<div className="flex items-center">
					<span className="text-base font-semibold mr-2">{tour.title}</span>
				</div>
			</div>
			<div className="flex items-center justify-end gap-3">
				<TourButton
					task={tour}
					className="px-3 py-2 leading-tight min-w-30 button-focus bg-gray-100 hover:bg-gray-200 focus:shadow-button text-gray-900 rounded-sm relative cursor-pointer text-center no-underline text-sm"
				/>
			</div>
		</>
	);
};
