<?php
/**
 * Attributes File.
 *
 * @since 2.1.0
 *
 * @package uagb
 */

$arrow_border_attributes      = UAGB_Block_Helper::uag_generate_border_attribute(
	'arrow',
	array(
		'borderStyle'             => 'none',
		'borderTopWidth'          => 4,
		'borderRightWidth'        => 4,
		'borderBottomWidth'       => 4,
		'borderLeftWidth'         => 4,
		'borderTopLeftRadius'     => 50,
		'borderTopRightRadius'    => 50,
		'borderBottomLeftRadius'  => 50,
		'borderBottomRightRadius' => 50,
	)
);
$btn_border_attributes        = UAGB_Block_Helper::uag_generate_border_attribute( 'btn' );
$image_border_attributes      = UAGB_Block_Helper::uag_generate_border_attribute( 'image' );
$main_title_border_attributes = UAGB_Block_Helper::uag_generate_border_attribute(
	'mainTitle',
	array(
		'borderTopWidth'    => 2,
		'borderRightWidth'  => 0,
		'borderBottomWidth' => 2,
		'borderLeftWidth'   => 0,
	)
);

return array_merge(
	array(
		// Block Requirements.
		'block_id'                           => '',
		'classMigrate'                       => false,
		// Editor Requirements.
		'readyToRender'                      => false,
		'tileSize'                           => 0,
		'focusList'                          => array(),
		'focusListObject'                    => array(),

		// Gallery Settings.
		'mediaGallery'                       => array(),
		'mediaIDs'                           => array(),
		'feedLayout'                         => 'grid',
		'imageDisplayCaption'                => true,
		'galleryImageSize'                   => 'large',
		'galleryImageSizeTablet'             => 'large',
		'galleryImageSizeMobile'             => 'medium',
		'imageClickEvent'                    => 'none',
		// Lightbox Settings.
		'lightboxDisplayCaptions'            => false,
		'lightboxThumbnails'                 => false,
		'lightboxDisplayCount'               => false,
		'lightboxCloseIcon'                  => 'xmark',
		'lightboxCaptionHeight'              => 50,
		'lightboxCaptionHeightTablet'        => '',
		'lightboxCaptionHeightMobile'        => '',
		'lightboxIconSize'                   => 24,
		'lightboxIconSizeTablet'             => '',
		'lightboxIconSizeMobile'             => '',
		// Caption Settings.
		'captionVisibility'                  => 'hover',
		'captionDisplayType'                 => 'overlay',
		'imageCaptionAlignment'              => 'center center',
		'imageCaptionAlignment01'            => 'center',
		'imageCaptionAlignment02'            => 'center',
		'imageDefaultCaption'                => __( 'No Caption', 'ultimate-addons-for-gutenberg' ),
		'captionPaddingTop'                  => 8,
		'captionPaddingRight'                => 8,
		'captionPaddingBottom'               => 8,
		'captionPaddingLeft'                 => 8,
		'captionPaddingTopTab'               => 8,
		'captionPaddingRightTab'             => 8,
		'captionPaddingBottomTab'            => 8,
		'captionPaddingLeftTab'              => 8,
		'captionPaddingTopMob'               => 8,
		'captionPaddingRightMob'             => 8,
		'captionPaddingBottomMob'            => 8,
		'captionPaddingLeftMob'              => 8,
		'captionPaddingUnit'                 => 'px',
		'captionPaddingUnitTab'              => 'px',
		'captionPaddingUnitMob'              => 'px',
		'captionPaddingUnitLink'             => true,
		'captionGap'                         => 0,
		'captionGapUnit'                     => 'px',
		// Layout Settings.
		'columnsDesk'                        => 3,
		'columnsTab'                         => 3,
		'columnsMob'                         => 2,
		'gridImageGap'                       => 8,
		'gridImageGapTab'                    => '',
		'gridImageGapMob'                    => '',
		'gridImageGapUnit'                   => 'px',
		'gridImageGapUnitTab'                => 'px',
		'gridImageGapUnitMob'                => 'px',
		'feedMarginTop'                      => '',
		'feedMarginRight'                    => '',
		'feedMarginBottom'                   => '',
		'feedMarginLeft'                     => '',
		'feedMarginTopTab'                   => '',
		'feedMarginRightTab'                 => '',
		'feedMarginBottomTab'                => '',
		'feedMarginLeftTab'                  => '',
		'feedMarginTopMob'                   => '',
		'feedMarginRightMob'                 => '',
		'feedMarginBottomMob'                => '',
		'feedMarginLeftMob'                  => '',
		'feedMarginUnit'                     => 'px',
		'feedMarginUnitTab'                  => 'px',
		'feedMarginUnitMob'                  => 'px',
		'feedMarginUnitLink'                 => true,
		// Layout Specific Settings.
		'carouselStartAt'                    => 0,
		'carouselSquares'                    => false,
		'carouselLoop'                       => true,
		'carouselAutoplay'                   => true,
		'carouselAutoplaySpeed'              => 2000,
		'carouselPauseOnHover'               => true,
		'carouselTransitionSpeed'            => 500,
		'gridPages'                          => 1,
		'gridPageNumber'                     => 1,
		// Pagination Settings.
		'feedPagination'                     => false,
		'paginateUseArrows'                  => true,
		'paginateUseDots'                    => true,
		'paginateUseLoader'                  => true,
		'paginateLimit'                      => 9,
		'paginateButtonAlign'                => 'center',
		'paginateButtonText'                 => __( 'Load More Images', 'ultimate-addons-for-gutenberg' ),
		'paginateButtonPaddingTop'           => '',
		'paginateButtonPaddingRight'         => '',
		'paginateButtonPaddingBottom'        => '',
		'paginateButtonPaddingLeft'          => '',
		'paginateButtonPaddingTopTab'        => '',
		'paginateButtonPaddingRightTab'      => '',
		'paginateButtonPaddingBottomTab'     => '',
		'paginateButtonPaddingLeftTab'       => '',
		'paginateButtonPaddingTopMob'        => '',
		'paginateButtonPaddingRightMob'      => '',
		'paginateButtonPaddingBottomMob'     => '',
		'paginateButtonPaddingLeftMob'       => '',
		'paginateButtonPaddingUnit'          => 'px',
		'paginateButtonPaddingUnitTab'       => 'px',
		'paginateButtonPaddingUnitMob'       => 'px',
		'paginateButtonPaddingUnitLink'      => true,
		// Image Styling.
		'imageEnableZoom'                    => true,
		'imageZoomType'                      => 'zoom-in',
		'captionBackgroundEnableBlur'        => false,
		'captionBackgroundBlurAmount'        => 0,
		'captionBackgroundBlurAmountHover'   => 5,
		// Lightbox Styling.
		'lightboxEdgeDistance'               => 10,
		'lightboxEdgeDistanceTablet'         => '',
		'lightboxEdgeDistanceMobile'         => '',
		'lightboxBackgroundEnableBlur'       => true,
		'lightboxBackgroundBlurAmount'       => 5,
		'lightboxBackgroundColor'            => 'rgba(0,0,0,0.75)',
		'lightboxIconColor'                  => 'rgba(255,255,255,1)',
		'lightboxCaptionColor'               => 'rgba(255,255,255,1)',
		'lightboxCaptionBackgroundColor'     => 'rgba(0,0,0,1)',
		// Caption Typography Styling.
		'captionLoadGoogleFonts'             => false,
		'captionFontFamily'                  => 'Default',
		'captionFontWeight'                  => '',
		'captionFontStyle'                   => 'normal',
		'captionTransform'                   => '',
		'captionDecoration'                  => 'none',
		'captionFontSizeType'                => 'px',
		'captionFontSize'                    => '',
		'captionFontSizeTab'                 => '',
		'captionFontSizeMob'                 => '',
		'captionLineHeightType'              => 'em',
		'captionLineHeight'                  => '',
		'captionLineHeightTab'               => '',
		'captionLineHeightMob'               => '',
		// Pagination Button Typography Styling.
		'loadMoreLoadGoogleFonts'            => false,
		'loadMoreFontFamily'                 => 'Default',
		'loadMoreFontWeight'                 => '',
		'loadMoreFontStyle'                  => 'normal',
		'loadMoreTransform'                  => '',
		'loadMoreDecoration'                 => 'none',
		'loadMoreFontSizeType'               => 'px',
		'loadMoreFontSize'                   => '',
		'loadMoreFontSizeTab'                => '',
		'loadMoreFontSizeMob'                => '',
		'loadMoreLineHeightType'             => 'em',
		'loadMoreLineHeight'                 => '',
		'loadMoreLineHeightTab'              => '',
		'loadMoreLineHeightMob'              => '',
		// Lightbox Typography Styling.
		'lightboxLoadGoogleFonts'            => false,
		'lightboxFontFamily'                 => 'Default',
		'lightboxFontWeight'                 => '',
		'lightboxFontStyle'                  => 'normal',
		'lightboxTransform'                  => '',
		'lightboxDecoration'                 => 'none',
		'lightboxFontSizeType'               => 'px',
		'lightboxFontSize'                   => '',
		'lightboxFontSizeTab'                => '',
		'lightboxFontSizeMob'                => '',
		'lightboxLineHeightType'             => 'em',
		'lightboxLineHeight'                 => '',
		'lightboxLineHeightTab'              => '',
		'lightboxLineHeightMob'              => '',
		// Hoverable Styling.
		'captionBackgroundEffect'            => 'none',
		'captionBackgroundEffectHover'       => 'none',
		'captionBackgroundEffectAmount'      => 100,
		'captionBackgroundEffectAmountHover' => 0,
		'captionColor'                       => 'rgba(255,255,255,1)',
		'captionColorHover'                  => 'rgba(255,255,255,1)',
		'captionBackgroundColor'             => 'rgba(0,0,0,0.75)',
		'captionBackgroundColorHover'        => 'rgba(0,0,0,0.75)',
		'overlayColor'                       => 'rgba(0,0,0,0)',
		'overlayColorHover'                  => 'rgba(0,0,0,0)',
		'captionSeparateColors'              => false,
		// Pagination Styling.
		'paginateArrowDistance'              => -24,
		'paginateArrowDistanceUnit'          => 'px',
		'paginateArrowSize'                  => 24,
		'paginateDotDistance'                => 8,
		'paginateDotDistanceUnit'            => 'px',
		'paginateLoaderSize'                 => 18,
		'paginateButtonTextColor'            => '',
		'paginateButtonTextColorHover'       => '',
		'paginateColor'                      => '',
		'paginateColorHover'                 => '',
		// Box Shadow Styling.
		'imageBoxShadowColor'                => '',
		'imageBoxShadowHOffset'              => 0,
		'imageBoxShadowVOffset'              => 0,
		'imageBoxShadowBlur'                 => '',
		'imageBoxShadowSpread'               => '',
		'imageBoxShadowPosition'             => 'outset',
		'imageBoxShadowColorHover'           => '',
		'imageBoxShadowHOffsetHover'         => 0,
		'imageBoxShadowVOffsetHover'         => 0,
		'imageBoxShadowBlurHover'            => '',
		'imageBoxShadowSpreadHover'          => '',
		'imageBoxShadowPositionHover'        => 'outset',
	),
	$arrow_border_attributes,
	$btn_border_attributes,
	$image_border_attributes,
	$main_title_border_attributes,
	array(
		'arrowBorderStyle'             => 'none',
		'arrowBorderTopWidth'          => 4,
		'arrowBorderRightWidth'        => 4,
		'arrowBorderBottomWidth'       => 4,
		'arrowBorderLeftWidth'         => 4,
		'arrowBorderTopLeftRadius'     => 50,
		'arrowBorderTopRightRadius'    => 50,
		'arrowBorderBottomLeftRadius'  => 50,
		'arrowBorderBottomRightRadius' => 50,
	),
	array(
		'mainTitleBorderTopWidth'    => 2,
		'mainTitleBorderRightWidth'  => 0,
		'mainTitleBorderBottomWidth' => 2,
		'mainTitleBorderLeftWidth'   => 0,
	)
);
