<?php
namespace WprAddons\Admin\Templates\Library;

use WprAddons\Plugin;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class WPR_Templates_Data {
	public static function get_available_kits() {
		$is_pro_active = wpr_fs()->can_use_premium_code() && defined('WPR_ADDONS_PRO_VERSION');
		$is_expert = $is_pro_active && wpr_fs()->is_plan( 'expert' );
		$is_cf7_active = is_plugin_active('contact-form-7/wp-contact-form-7.php') ? 'true' : 'false';
		$is_mla_active = is_plugin_active('media-library-assistant/index.php') ? 'true' : 'false';
		$is_woo_active = is_plugin_active('woocommerce/woocommerce.php') ? 'true' : 'false';

		return [
			'grocery-store' => [
				'v1' => [
					'name' => 'Grocery Store - Shop',
					'pages' => 'home,shop,single-product,my-account,about,contact,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'grocery store shop shopping woo-commerce woocommerce estore ecommerce product online eshopping market reseller ecommerce shop organic food natural e commerce food veggies bio organic',
					'theme-builder' => false,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => 'trending',
					'priority' => 10,
				],
				'v2' => [
					'name' => 'Grocery Store - Shop V2',
					'pages' => 'home,shop,single-product,variable-product,grouped-product,cart,wishlist,compare,about,blog,contact,contact-v1,contact-v2',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'grocery store shop shopping woo-commerce woocommerce estore ecommerce product online eshopping market reseller ecommerce shop organic food natural e commerce food veggies bio organic',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'expert' => $is_expert ? 'free' : 'expert',
					'label' => 'new',
					'priority' => 4,
				],
			],
			'landing-page-ebook' => [
				'v1' => [
					'name' => 'Landing Page - Ebook',
					'pages' => 'home,featured-books,benefits,authors,blog,single-blog,',
					'plugins' => '{}',
					'tags' => 'free ebook e-book e book single page landing page one page onepage landingpage authors books marketing promotion',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 50,
				],
			],
			'amazon-landing-page' => [
				'v1' => [
					'name' => 'Amazon Product Landing Page',
					'pages' => 'home,',
					'plugins' => '{}',
					'tags' => 'amazon product sale coupon free page landing page one page onepage landingpage marketing promotion landing page for amazon single product digital product coupon',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 50,
				],
			],
			'coming-soon-pack' => [
				'v1' => [
					'name' => 'Coming Soon Pack',
					'pages' => 'home,coming-soon-v2,coming-soon-v3,coming-soon-v4,coming-soon-v5,',
					'plugins' => '{}',
					'tags' => 'coming soon page launch maintenance mode countdown underconstruciton under construction comingsoon landingpage landing page',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 150,
				],
			],
			'music-band' => [
				'v1' => [
					'name' => 'Music Band',
					'pages' => 'home,bio,shop,single-product,news,events,contact,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'music band music-industry dj events tickets festival merchandise sound entertainment nightlife disco party club artist audio musician shop soundcloud instrument',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 151,
				],
			],
			'dental' => [
				'v1' => [
					'name' => 'Dental Clinic',
					'pages' => 'home,about,services,reviews,contact,',
					'plugins' => '{}',
					'tags' => 'dental clinic dental-care dentistry orthodontics tooth therapy free medical clinic dental health healthcare doctor therapist wellness treatment cure',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 152,
				],
			],
			'landing-page-startup' => [
				'v1' => [
					'name' => 'Landing Page - Startup',
					'pages' => 'home,features,metrics,blog,single-blog,',
					'plugins' => '{}',
					'tags' => 'free digital product single-page landing page one page onepage landingpage agency digital app business corporate creative lead capture marketing startup',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 51,
				],
			],
			'landing-page-saas' => [
				'v1' => [
					'name' => 'Landing Page - SAAS',
					'pages' => 'home,features,collaboration,solutions,',
					'plugins' => '{}',
					'tags' => 'free digital product single-page landing page one page onepage landingpage digital app business corporate creative startup php script saas php code',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 50,
				],
			],
			'landing-page-business' => [
				'v1' => [
					'name' => 'Landing Page - Business',
					'pages' => 'home,business-plan,insight,features,blog,single-blog,',
					'plugins' => '{}',
					'tags' => 'free digital product single-page landing page one page onepage landingpage agency digital app business corporate creative lead capture marketing startup',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 1,
				],
			],
			'landing-page-digital-product' => [
				'v1' => [
					'name' => 'Landing Page - Digital Product',
					'pages' => 'home,features,analytics,benefits,blog,',
					'plugins' => '{}',
					'tags' => 'free digital product single-page landing page one page onepage landingpage agency digital app business corporate creative lead capture marketing startup',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 5,
				],
			],
			'landing-page-mobileapp' => [
				'v1' => [
					'name' => 'Landing Page - Mobile App',
					'pages' => 'product,features,security,solutions,',
					'plugins' => '{}',
					'tags' => 'digital free mobile app product landing page one page onepage landingpage digital app solutions connect mobile app app website android ios iphone saas web appilication',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 51,
				],
			],
			'landing-page-investment-platform' => [
				'v1' => [
					'name' => 'Landing Page - Investment Platform',
					'pages' => 'home,investing,options,startup,overview,',
					'plugins' => '{}',
					'tags' => 'free startup investment platform single page landing page one page onepage landingpage finance fintech business stock trade',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 50,
				],
			],
			'furniture-shop' => [
				'v1' => [
					'name' => 'Furniture Shop',
					'pages' => 'home,shop-v1,shop-v2,single-product,my-account,about,contact,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'shop shopping woo-commerce woocommerce estore ecommerce product online furniture home office eshopping market reseller ecommerce shop e commerce',
					'theme-builder' => false,
					'woo-builder' => true,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'pro',
					'expert' => $is_expert ? 'free' : 'expert',
					'label' => 'trending',
					'priority' => 5,
				],
			],
			'ecommerce' => [
				'v1' => [
					'name' => 'Ecommerce - Shop',
					'pages' => 'home,shop,single-product,blog,minicart,about,contact,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'shop shopping woo-commerce woocommerce estore store ecommerce product ecommerce shop online boutique clothes eshopping fashion designer market reseller digital purchases e commerce',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'expert' => $is_expert ? 'free' : 'expert',
					'label' => 'new',
					'priority' => 8,
				],
			],
			'estore' => [
				'v1' => [
					'name' => 'Electronic Store - Shop',
					'pages' => 'home,shop,single-product,blog,faq,about,contact,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'shop shopping woo-commerce woocommerce estore ecommerce product online market reseller ecommerce shop gadget iphone phone electronic e commerce',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'expert' => $is_expert ? 'free' : 'expert',
					'label' => 'hot',
					'priority' => 4,
				],
			],
			'woo-food' => [
				'v1' => [
					'name' => 'Food Delivery - Shop',
					'pages' => 'home,home-v2,food,single-product,about,contact,faq,blog,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .',"woocommerce":'. $is_woo_active .'}',
					'tags' => 'menu shop woo-commerce woocommerce ecommerce product online eshopping market ecommerce shop food delivery restaurant fast food pizzeria burger recipes cooking pizza restaurant snack e commerce',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => 'trending',
					'priority' => 144,
				],
			],
			'fashion' => [
				'v1' => [
					'name' => 'Fashion 1 - Shop',
					'pages' => 'home,shop-v1,shop-v2,single-product,blog,my-account,about,faq,contact,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'shop shopping woo-commerce woocommerce estore ecommerce product ecommerce shop online boutique clothes eshopping fashion designer market reseller digital purchases e commerce',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'expert' => $is_expert ? 'free' : 'expert',
					'label' => 'trending',
					'priority' => 5,
				],
				'v2' => [
					'name' => 'Fashion 2 - Shop',
					'pages' => 'home,home-v2,home-v3,shop-v1,shop-v2,shop-v3,megamenu,ajaxsearch,compare,wishlist,minicart,single-product,blog,about-v1,about-v2,contact-v1,contact-v2,contact-v3,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'shop shopping woo-commerce woocommerce estore store ecommerce product ecommerce shop online boutique clothes eshopping fashion designer market reseller digital purchases e commerce',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'expert' => $is_expert ? 'free' : 'expert',
					'label' => 'trending',
					'priority' => 3,
				],
			],
			'wooshop' => [
				'v1' => [
					'name' => 'Woo Shop V1',
					'pages' => 'home,shop,single-product,about,contact,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'free shop shopping woo-commerce woocommerce estore ecommerce shop ecommerce product online shop online store boutique clothes eshopping fashion designer market reseller digital purchases e commerce',
					'theme-builder' => false,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 3,
				],
			],
			'shop-wooshop' => [
				'v2' => [
					'name' => 'Woo Shop V2',
					'pages' => 'home,shop,single-product,about,cart,contact,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'free shop shopping woo-commerce woocommerce estore ecommerce shop ecommerce product online shop online store boutique clothes eshopping fashion designer market reseller digital purchases e commerce',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'New',
					'priority' => 4,
				],
			],
			'woo-auto-parts' => [
				'v1' => [
					'name' => 'Auto Parts Store - Car',
					'pages' => 'home,shop,single-product,compare,mini-cart,about,contact,blog,mega-menu',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'auto parts store shop shopping woo-commerce woocommerce estore ecommerce product online eshopping market car parts automobile accessories bike parts car repair tire shop tools shop phone parts e commerce',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'pro',
					'expert' => $is_expert ? 'free' : 'expert',
					'label' => 'new',
					'priority' => 4,
				],
			],
			'personal-blog' => [
				'v1' => [
					'name' => 'Personal Blog v1',
					'pages' => 'home,home-v1,home-v2,home-v3,lifestyle,about,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'blog blogger posts personal blog lifestyle blogger theme builder grid slider news magazine',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => 'trending',
					'priority' => 20,
				],
				'v2' => [
					'name' => 'Personal Blog v2',
					'pages' => 'home,single,category,about,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'free blog blogger posts personal blog lifestyle blogger theme builder grid slider news magazine',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'trending',
					'priority' => 4,
				],
				'v3' => [
					'name' => 'Personal Blog v3',
					'pages' => 'home,blog-v1,blog-v2,blog-v3,instagram feed,ajax search,about,contact,single post,',
					'plugins' => '{}',
					'tags' => 'free blog blogger posts personal blog lifestyle blogger theme builder grid slider news magazine',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'trending',
					'priority' => 2,
				],
				'v4' => [
					'name' => 'Personal Blog v4',
					'pages' => 'home,home-v2,home-v3,home-v4,single-blog,about,contact,',
					'plugins' => '{}',
					'tags' => 'free blog blogger posts personal blog lifestyle blogger theme builder grid slider news magazine cute',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 1,
				],
			],
			'hotel' => [
				'v1' => [
					'name' => 'Hotel',
					'pages' => 'home,dining,rooms,services,history,gallery,contact,',
					'plugins' => '{"media-library-assistant":'. $is_mla_active .'}',
					'tags' => 'hotel motel rooms apartment guest house budget hotel lodge lodging resort bnb accommodation resort travel tourism luxury hotel',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 20,
				],
			],
			'fitness-gym' => [
				'v1' => [
					'name' => 'Fitness Gym',
					'pages' => 'home,about,gallery,classes,pricing,gallery,review,trainers,contact,comingsoon,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .', "media-library-assistant":'. $is_mla_active .'}',
					'tags' => 'free personal trainer gym fitness yoga exercises workout cardio strength training weightlifting crossfit hiit bodyweight exercises muscle building bodybuilding powerlifting',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 21,
				],
			],
			'food-blog' => [
				'v1' => [
					'name' => 'Food Blog',
					'pages' => 'home,home-v1,home-v2,home-v3,category,about,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'menu food blog posts food blogger theme builder recipes cooking grid slider magazine',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 20,
				],
			],
			'magazine-blog' => [
				'v1' => [
					'name' => 'Magazine Blog v1',
					'pages' => 'home,home-v1,home-v2,category,about,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'blogger blog posts content news newspaper journal magazine business blog publishing theme builder sports grid slider magazine',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => 'trending',
					'priority' => 60,
				],
				'v2' => [
					'name' => 'Magazine Blog v2',
					'pages' => 'home,home-v1,home-v2,category,about,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'blogger blog posts content news newspaper journal magazine business blog publishing theme builder sports grid slider magazine',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 50,
				],
				'v3' => [
					'name' => 'Magazine Blog v3',
					'pages' => 'home,category,about,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'blogger blog posts content news newspaper journal magazine business blog publishing theme builder sports grid slider magazine',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 30,
				],
				'v4' => [
					'name' => 'Magazine Blog v4',
					'pages' => 'home,home-v1,home-v2,home-v3,category,shop,cart,mega-menu-1,mega-menu-2,contact,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'blogger blog posts content news newspaper journal magazine business blog publishing theme builder sports grid slider magazine',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => 'new',
					'priority' => 6,
				],
				'v6' => [
					'name' => 'Magazine Blog v6',
					'pages' => 'home,category,single-blog,contact,',
					'plugins' => '{}',
					'tags' => 'blogger blog posts content news newspaper journal magazine business blog publishing theme builder sports grid slider magazine',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 6,
				],
			],
			'yoga' => [
				'v1' => [
					'name' => 'yoga',
					'pages' => 'home,about,classes,testimonials,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'free personal trainer gym fitness yoga stydio yoga trainer exercises workout cardio strength training weightlifting crossfit hiit bodyweight exercises muscle building bodybuilding powerlifting',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 100,
				],
			],
			'nature' => [
				'v1' => [
					'name' => 'Nature v1 - travel',
					'pages' => 'home,about,services,projects,contact,',
					'plugins' => '{}',
					'tags' => 'free nature influencer travel content slider tourism influencers creator travel forest slider generic multipurpose national-park nature-park sanctuary wilderness hitchhiking mountain river lakes outdoors',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'trending',
					'priority' => 1,
				],
				'v2' => [
					'name' => 'Nature v2 - travel',
					'pages' => 'home,about,services,blog,contact,',
					'plugins' => '{}',
					'tags' => 'free nature influencer travel content slider tourism influencers creator travel forest slider generic multipurpose national-park nature-park sanctuary wilderness hitchhiking mountain river lakes outdoors',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 1,
				],
			],
			'travel-agency' => [
				'v1' => [
					'name' => 'Travel agency',
					'pages' => 'home,tours,gallery,services,reviews,about,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'nature influencer travel content slider tourism influencers creator travel forest slider generic multipurpose national-park nature-park sanctuary wilderness hitchhiking mountain river lakes outdoors travel agency company office travel services',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 61,
				],
			],
			'home-care' => [
				'v1' => [
					'name' => 'Home Care - Senior Care Service',
					'pages' => 'home,about,services,appointment,blog,contact,',
					'plugins' => '{}',
					'tags' => 'free homecare medication management medical elderly home assisted living facility elder home elder care old age home elders care retirement home health healthcare senior living old care senior living senior care services retirement home eldery care hospital nurse retire',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 200,
				],
			],
			'designer-bio' => [
				'v1' => [
					'name' => 'Designer Bio V1',
					'pages' => 'home,',
					'plugins' => '{}',
					'tags' => 'free portfolio personal cv designer ux artist artwork personal resume photographer grid one page onepage clean creative freelanceer vcard',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 200,
				],
			],
			'digital-marketing-agency' => [
				'v1' => [
					'name' => 'Digital Marketing Agency v1',
					'pages' => 'home,seo,branding,marketing,social,blog,about,contact,',
					'plugins' => '{}',
					'tags' => 'digital agency company corporate digital services office agency web digital marketing seo social media branding',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 3,
				],
				'v2' => [
					'name' => 'Digital Marketing Agency v2',
					'pages' => 'home,seo,social,web,email,shop,blog,about,team,contact,pricing1,pricing2,pricing3,casestudy,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'digital agency company corporate digital services office agency web digital marketing seo social media branding e commerce',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 2,
				],
				'v3' => [
					'name' => 'Digital Marketing Agency v3',
					'pages' => 'home,services,portfolio,blog,about,contact,',
					'plugins' => '{}',
					'tags' => 'digital agency company corporate digital services office agency web digital marketing seo social media branding',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 2,
				],
			],
			'digital-seo-marketing-agency' => [
				'v1' => [
					'name' => 'Digital SEO Marketing Agency v1',
					'pages' => 'home,about,services,team,projects,details,pricing,blog,faq,contact,',
					'plugins' => '{}',
					'tags' => 'digital agency company corporate digital services office agency web digital marketing seo social media branding dark black digital seo agency',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => 'new',
					'priority' => 4,
				],
				'v2' => [
					'name' => 'Digital SEO Marketing Agency v2',
					'pages' => 'home,about,solutions,awards,careers,work,email-marketing,paid-search-marketing,search-engine-optimization,contact,blog',
					'plugins' => '{}',
					'tags' => 'digital agency company corporate digital services solutions agency web digital marketing seo social media branding dark black digital seo agency acf dynamic',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'pro',
					'expert' => $is_expert ? 'free' : 'expert',
					'custom-types' => ['wpr-work' => 'wpr_work', 'wpr-work-category' => 'wpr_work_cats'],
					'label' => 'new',
					'priority' => 3,
				],
			],
			'digital-agency-dark' => [
				'v1' => [
					'name' => 'Digital Agency Dark v1',
					'pages' => 'home,about,services,team,portfolio,blog,contact,',
					'plugins' => '{"media-library-assistant":'. $is_mla_active .'}',
					'tags' => 'digital agency company corporate digital services office agency web digital marketing seo social media branding dark black',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 4,
				],
			],
			'one-page' => [
				'v1' => [
					'name' => 'OnePage - Digital Marketing Agency',
					'pages' => 'home,blog,',
					'plugins' => '{"media-library-assistant":'. $is_mla_active .'}',
					'tags' => 'digital agency company corporate digital services office agency web digital marketing seo social media branding one page onepage one pages parallax single page landing page',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 7,
				],
				'v2' => [
					'name' => 'OnePage Kit - Digital Agency',
					'pages' => 'home,about-us,features,services,team,contact,shop,blog,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'marketing insight revenue product sales business solutions one page onepage one pages single page landing page shop digital agency digital marketing agency portfolio product freelancer',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 7,
				],
			],
			'travel-blog' => [
				'v1' => [
					'name' => 'Travel Blog',
					'pages' => 'home,home-v1,home-v2,category,about,contact,',
					'plugins' => '{}',
					'tags' => 'free nature influencer travel blogger blog posts content tourism influencers creator travel forest slider generic multipurpose national-park nature-park sanctuary wilderness slider hitchhiking mountain river lakes outdoors theme builder traveler hiking grid magazine',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 71,
				],
			],
			'portfolio' => [
				'v1' => [
					'name' => 'Portfolio/CV v1',
					'pages' => 'home,about,portfolio,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'free portfolio personal cv designer ux artist artwork personal resume photographer grid clean creative freelanceer vcard',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 81,
				],
			   'v2' => [
					'name' => 'Portfolio/CV - One Page v2',
					'pages' => 'home,single project,',
					'plugins' => '{}',
					'tags' => 'free portfolio personal cv designer ux artist artwork personal resume photographer grid one page onepage clean creative freelanceer vcard',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 80,
				],
			],
			'developer-portfolio' => [
				'v1' => [
					'name' => 'Developer Portfolio - v1',
					'pages' => 'home,portfolio,about,services,resume,contact,',
					'plugins' => '{}',
					'tags' => 'web developer portfolio dev projects work resume coding code app design software free portfolio personal cv designer ux artist artwork personal resume creative freelanceer vcard',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 3,
				],
			],
			'nft-portfolio' => [
				'v1' => [
					'name' => 'NFT',
					'pages' => 'home,about,blog,roadmap,team,nft,faq,comingsoon,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'portfolio blockchain nft crypto collection minting listing metavers digital currency art',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 81,
				],
			],
			'pizza' => [
				'v1' => [
					'name' => 'Pizza Restaurant',
					'pages' => 'home,menu,about,offer,gallery,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'pizza italian restaurant food slider pasta fastfood fast food recipes cooking slider menu',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 90,
				],
			],
			'business-consulting' => [
				'v1' => [
					'name' => 'Business Consulting',
					'pages' => 'home,about,blog,contact,services,contact,faq,history,pricing,team',
					'plugins' => '{}',
					'tags' => 'cryptocurrency crypto blockchain advisor investment corporate finance finances financial penny grow financial consulting financial advisors fintech fintech startup business consultancy firm business consulting company financial consulting consultancy services sales marketing technology consulting business coach business consultant business guide mentor motivational speaker',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => 'new',
					'priority' => 51,
				],
			],
			'fintech' => [
				'v1' => [
					'name' => 'Fintech Startup Website',
					'pages' => 'home,about,services,blog,contact,',
					'plugins' => '{}',
					'tags' => 'free cryptocurrency crypto blockchain advisor investment corporate finance finances financial penny grow financial consulting financial advisors fintech fintech startup business consultancy firm business consulting company financial consulting consultancy services sales technology consulting business coach business consultant business guide mentor motivational speaker',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 201,
				],
			],
			'car-repair' => [
				'v1' => [
					'name' => 'Car Repair',
					'pages' => 'home,about,contact,services,team,',
					'plugins' => '{}',
					'tags' => 'free car repair cars car care car detailing car repair repair car service vehicle auto vehicle',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 4,
				],
			],
			'pet-care' => [
				'v1' => [
					'name' => 'Pet Care',
					'pages' => 'home,about,services,reviews,contact,',
					'plugins' => '{}',
					'tags' => 'free pet care dog care grooming pet minding pet sitting pet training pet walking cat animal dogs dog training',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 91,
				],
			],
			'pet-shop' => [
				'v1' => [
					'name' => 'Pet Shop V1',
					'pages' => 'home,shop,single-product,cart,blog,single-blog,about,contact,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'shop shopping woo-commerce woocommerce estore store ecommerce product ecommerce shop online pet shop petshop purchases e commerce free pet care dog care grooming pet minding pet sitting pet training pet walking cat animal dogs dog training',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 92,
				],
			],
			'travel' => [
				'v1' => [
					'name' => 'Travel Blogger & Influencer',
					'pages' => 'home,about,stories,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'free nature influencer travel blogger blog content tourism influencers creator travel forest slider generic multipurpose national-park nature-park sanctuary wilderness hitchhiking mountain river lakes outdoors',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 100,
				],
				'v3' => [
					'name' => 'Travel V3',
					'pages' => 'home,about,tours,tours-details,gallery,blog,single-blog,contact,',
					'plugins' => '{}',
					'tags' => 'nature influencer travel content slider tourism influencers creator travel forest slider generic multipurpose national-park nature-park sanctuary wilderness hitchhiking mountain river lakes outdoors travel agency company office travel service',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 10,
				]
			],
			'cybersecurity' => [
				'v1' => [
					'name' => 'Cybersecurity',
					'pages' => 'home,about,services,pricing,contact,',
					'plugins' => '{}',
					'tags' => 'cybersecurity data protection hacker security dark digital technology cybercrime computer windows technician',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 110,
				],
			],
			'charity' => [
				'v1' => [
					'name' => 'Charity',
					'pages' => 'home,home-v1,contact,whatwedo,whoweare,partners,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'charity donate church foundation giving non-profit organization kids charity help children save life donation fundrising ngo fundraising corona fundraising nonprofit non profit',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 111,
				],
			],
			'photographer' => [
				'v1' => [
					'name' => 'Photographer Portfolio Dark',
					'pages' => 'home,about,services,portfolio,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .', "media-library-assistant":'. $is_mla_active .'}',
					'tags' => 'portfolio personal cv designer ux artist artwork personal resume camera fashion lens modelling photographer photography videography wedding shoot grid',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 120,
				],
				'v2' => [
					'name' => 'Photographer Portfolio Light',
					'pages' => 'home,about,services,portfolio,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .', "media-library-assistant":'. $is_mla_active .'}',
					'tags' => 'portfolio personal cv designer ux artist artwork personal resume camera fashion lens modelling photographer photography videography wedding shoot grid',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 130,
				],
			],
			'cryptocurrency' => [
				'v1' => [
					'name' => 'Cryptocurrency',
					'pages' => 'home,about,services,token,pricing,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'cryptocurrency bitcoin ethereum etherium blockchain protection nft coin corporate crypto dark startup token digital',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 150,
				],
			],
			'skincare' => [
				'v1' => [
					'name' => 'Skin Care',
					'pages' => 'home,about,services,procedures,gallery,pricing,contact,',
					'plugins' => '{}',
					'tags' => 'free skincare skin care beauty clean face skin-beauty health wellness',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 160,
				],
			],
			'lawyer' => [
				'v1' => [
					'name' => 'Lawyer',
					'pages' => 'home,practice,faq,reviews,attorney,contact,',
					'plugins' => '{}',
					'tags' => 'free lawyers criminal defence lawyer firm divorce lawyer family lawyer law legal firm',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 170,
				],
			],
			'medical' => [
				'v1' => [
					'name' => 'Medical',
					'pages' => 'home,about,services,doctors,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'medical clinic dental health healthcare doctor therapist wellness treatment cure',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 180,
				],
			],
			'digitalagency' => [
				'v1' => [
					'name' => 'Digital Agency v1',
					'pages' => 'home,about,services,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'digital agency company corporate digital services office agency web marketing digital marketing',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 190,
				],
				'v2' => [
					'name' => 'Digital Agency v2',
					'pages' => 'home,about,services,pricing,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'digital agency company corporate digital services office agency web marketing slider digital marketing',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 200,
				],
				'v3' => [
					'name' => 'Digital Agency v3',
					'pages' => 'home,about,blog,single-blog,contact,',
					'plugins' => '{}',
					'tags' => 'free digital agency company corporate digital services office agency web marketing slider digital marketing',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 2,
				],
			],
			'digital-marketing' => [
				'v1' => [
					'name' => 'Digital Marketing V1 - One Page',
					'pages' => 'home,features,analytics,pricing,book-demo,contact',
					'plugins' => '{}',
					'tags' => 'digital agency company corporate digital services office agency web digital marketing seo social media branding landing page onepage one page',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 10,
				],
			],
			'jewelry' => [
				'v1' => [
					'name' => 'Jewelry Shop',
					'pages' => 'home,shop,single-product,cart,compare,wishlist,about,about-me,faq,blog,contact,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'shop shopping woo-commerce woocommerce estore ecommerce product online eshopping market ecommerce shop e commerce jewelry fashion store luxury diamond earrings gold jewelry care watch permanent jewelry diamond gold necklace ring earrings bracelet',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'expert' => $is_expert ? 'free' : 'expert',
					'label' => 'new',
					'priority' => 5,
				],
			],
			'drone' => [
				'v1' => [
					'name' => 'Drone Project',
					'pages' => 'home,about,gallery,services,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'free drone photography aerial photo',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 210,
				],
			],
			'architecture' => [
				'v1' => [
					'name' => 'Architecture v1',
					'pages' => 'home,about,portfolio,services,faq,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'architecture company slider interior design designer landscaping office zoning building slider architecture commercial construction creative decorations exterior designer home decorations interior designer landscape design modern residential',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 220,
				],
				'v2' => [
					'name' => 'Architecture v2',
					'pages' => 'home,about,projects,services,team,pricing,faq,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'architecture company slider interior design designer landscaping office zoning building slider architecture commercial construction creative decorations exterior designer home decorations interior designer landscape design modern residential',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 223,
				],
			],
			'fooddelivery' => [
				'v1' => [
					'name' => 'Food Delivery',
					'pages' => 'home,services,blog,faq,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'fooddelivery fast food chain restaurant service italian pasta pizza pizzeria burger recipes cooking menu',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 230,
				],
			],
			'construction' => [
				'v1' => [
					'name' => 'Construction v1',
					'pages' => 'home,about,services,projects,pricing,contact,faq,',
					'plugins' => '{}',
					'tags' => 'free construction architecture company interior office',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 240,
				],
				'v2' => [
					'name' => 'Construction v2',
					'pages' => 'home,about,services,projects,contact,',
					'plugins' => '{"media-library-assistant":'. $is_mla_active .'}',
					'tags' => 'construction architecture company building consultation',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => 'New',
					'priority' => 244,
				],
				'v3' => [
					'name' => 'Construction v3',
					'pages' => 'home,home-v2,about,services,megamenu,shop,single-product,minicart,blog,gallery,contact,',
					'plugins' => '{"woocommerce":'. $is_woo_active .', "media-library-assistant":'. $is_mla_active .'}',
					'tags' => 'construction architecture company building consultation e commerce',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => 'New',
					'priority' => 243,
					],
			],
			'ittech' => [
				'v1' => [
					'name' => 'IT Tech v1',
					'pages' => 'home,about,services,pricing,faq,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'ittech advanced technology it technique computer windows technician digital',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 5,
				],
				'v2' => [
					'name' => 'IT Tech v2',
					'pages' => 'home,about,services,pricing,faq,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'ittech advanced technology it technique computer windows technician digital',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 260,
				],
			],
			'aimatrix' => [
				'v1' => [
					'name' => 'AI Matrix - Data, Machines & AI ',
					'pages' => 'home,about,features,resources,case-study,contact,',
					'plugins' => '{}',
					'tags' => 'free data analysis machine learning ai automation algorithm autonomous processing artificial intelligence science generative quantum neuromorphic technology servers web IT tech crypto cyber ittech advanced technology it technique computer windows technician digital calculations computing digital chat gpt chatgpt bard gemini application',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 261,
				],
			],
			'carwash' => [
				'v1' => [
					'name' => 'Car Wash',
					'pages' => 'home,about,services,contact,',
					'plugins' => '{}',
					'tags' => 'free vehicle car wash cleaning painting service maintenance care bike motorcycle detailing auto',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 4,
				],
			],
			'realestate' => [
				'v1' => [
					'name' => 'Real Estate v1',
					'pages' => 'home,properties,about,services,faq,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'real estate agency company property rentals estate sales developers houses',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 271,
				],
				'v2' => [
					'name' => 'Real Estate v2',
					'pages' => 'home,about,services,property,details,agents,blog,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'real estate agency company property rentals estate sales developers houses',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'pro',
					'label' => '',
					'priority' => 272,
				],
				'v3' => [
					'name' => 'Real Estate Agency v3',
					'pages' => 'home,home-v2,about,directory,blog,contact,',
					'plugins' => '{}',
					'tags' => 'real estate agency company property rentals estate sales developers construction agency property rentals sales property agent flat homes rent sale listing realtor broker acf dynamic houses',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'pro',
					'expert' => $is_expert ? 'free' : 'expert',
					'custom-types' => ['wpr-directory' => 'wpr_directory'],
					'label' => 'New',
					'priority' => 270,
				],
			],
			'job-listing' => [
				'v1' => [
					'name' => 'Job Listing',
					'pages' => 'home,job-listing,job-details,about,blog,contact,',
					'plugins' => '{}',
					'tags' => 'job listing jobs job portal job board job search job site vacancy job vacancies career business consulting human research corporate business hiring recruiters directory resume recruitment acf dynamic',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'pro',
					'expert' => $is_expert ? 'free' : 'expert',
					'custom-types' => ['wpr-job-listing' => 'wpr_job_listing', 'wpr-job-industries' => 'wpr_job_industry'],
					'label' => 'new',
					'priority' => 105,
				],
			],
			'restaurant' => [
				'v1' => [
					'name' => 'Restaurant',
					'pages' => 'home,about,gallery,menu,contact,',
					'plugins' => '{}',
					'tags' => 'free restaurant fastfood slider hotel italian pizza pizzeria pasta dinner fast food wine recipe recipes cooking slider menu',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 280,
				],
			],
			'solar-energy' => [
				'v1' => [
					'name' => 'Solar Energy v1',
					'pages' => 'home,about,services,detail-service,projects,team,blog,contact,',
					'plugins' => '{}',
					'tags' => 'wind turbines photovoltaic green energy solar energy panel sustainable clean eco technology solar solutions solar power electronic electricity sun solar panels solar cells solar inverters solar batteries renewable energy sustainable energy solar module solar system solar inverter solar charger residential solar commercial solar water heating wind energy Renewable energy Wind power Wind farm',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 500,
				],
				'v2' => [
					'name' => 'Solar Energy v2',
					'pages' => 'home,about-us,services,projects,team,faq,blog,single-blog,contact,',
					'plugins' => '{}',
					'tags' => 'wind turbines photovoltaic green energy solar energy panel sustainable clean eco technology solar solutions solar power electronic electricity sun solar panels solar cells solar inverters solar batteries renewable energy sustainable energy solar module solar system solar inverter solar charger residential solar commercial solar water heating wind energy Renewable energy Wind power Wind farm',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 501,
				],
			],
			'winebar' => [
				'v1' => [
					'name' => 'Wine Bar & Restaurant',
					'pages' => 'home,story,wines,dishes,events,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'free wine bar winery beer drink alcohol pub events dish wines italian restaurant food slider recipes cooking recipes slider menu',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 290,
				],
			],
			'dance-studio' => [
				'v1' => [
					'name' => 'Landing Page - Dance Studio',
					'pages' => 'home,classes,instructors,gallery,blog,contact',
					'plugins' => '{}',
					'tags' => 'free single-page landing page one page onepage landingpage dance studio dancing dance school ballet contempo dance club fitness salsa zumba academy courses dancer music tango academy street dance jazz hiphop',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => true,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 200,
				],
			],
			'school' => [
				'v1' => [
					'name' => 'Children School V1',
					'pages' => 'home,about,classes,class-details,teachers,teacher-details,events,event-details,blog,single-blog,gallery,contact,',
					'plugins' => '{}',
					'tags' => 'free school education online-education learning homework educator teacher classes dance daycare elementary school home school kindergarten nursery preschool child children babysister childcare day care preschool baby sister daycare',
					'theme-builder' => true,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 10,
				],
			],
			'barbershop' => [
				'v1' => [
					'name' => 'Barbershop',
					'pages' => 'home,shop,single-product,barbers,schedule,services,blog,contact,',
					'plugins' => '{"woocommerce":'. $is_woo_active .'}',
					'tags' => 'hair dresser hairdresser parlor barbershop barbers shop barbers man hair cut barberry beard beauty salon mustache tattoo studio vintage Mens hair styling haircut',
					'theme-builder' => true,
					'woo-builder' => true,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => 'new',
					'priority' => 210,
				],
			],
			'wedding' => [
				'v1' => [
					'name' => 'Wedding',
					'pages' => 'home,about,services,blog,gallery,contact,',
					'plugins' => '{"contact-form-7":'. $is_cf7_active .'}',
					'tags' => 'free wedding party event slider invitation planner slider photography photographer',
					'theme-builder' => false,
					'woo-builder' => false,
					'off-canvas' => false,
					'price' => $is_pro_active ? 'free' : 'free',
					'label' => '',
					'priority' => 300,
				],
			],
		];
	}

	public static function get_available_kits_for_pages() {
		$is_pro_active = wpr_fs()->can_use_premium_code() && defined('WPR_ADDONS_PRO_VERSION');
		
		return [
			// 'woo-v1' => [
			// 	'name' => 'Food',
			// 	'pages' => ['home',],
			// 	'preview' => ['home',],
			// 	'price' => $is_pro_active ? 'free' : 'pro',
			// ],
			'digital-marketing-agency-v3' => [
				'name' => 'Digital Marketing Agency',
				'pages' => ['home','services','portfolio','blog','about','contact'],
				'preview' => ['home','services','portfolio','blog','about','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'nature-v1' => [
				'name' => 'Nature',
				'pages' => ['home','about','services','projects','contact'],
				'preview' => ['home','about','services','projects','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'nature-v2' => [
				'name' => 'Nature v2 - travel',
				'pages' => ['home','about','services','blog','contact'],
				'preview' => ['home','about','services','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'digital-marketing-agency-v2' => [
				'name' => 'Digital Marketing Agency',
				'pages' => ['home','seo','social','web','email','blog','about','team','contact','pricing1','pricing2','pricing3','casestudy'],
				'preview' => ['home','search-engine-optimization','social-media-marketing','web-design','email-marketing','blog','about-us','our-team','contact','price-pack-v1','price-pack-v2','price-pack-v3','case-study'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'fashion-v2' => [
				'name' => 'Fashion',
				'pages' => ['home','home-v2','home-v3','shop-v1','shop-v2','shop-v3','blog','about-v1','about-v2','contact-v1','contact-v2','contact-v3',],
				'preview' => ['home','home-v2','home-v3','shop-fashion-v2','shop-v2','shop-grid-list-view','blog','about','about-v2','contact','contact-v2','contact-v3',],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'digitalagency-v3' => [
				'name' => 'Digital Agency',
				'pages' => ['home','about','blog','contact'],
				'preview' => ['home','about','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'realestate-v3' => [
				'name' => 'Real Estate v3',
				'pages' => ['home','home-v2','about','directory','blog','contact'],
				'preview' => ['home','home-v2','about','directory','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'realestate-v2' => [
				'name' => 'Real Estate',
				'pages' => ['home','about','services','property','details','agents','blog','contact'],
				'preview' => ['home','about','services','property','property-details','agents','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'realestate-v1' => [
				'name' => 'Real Estate',
				'pages' => ['home','properties','about','services','faq','contact'],
				'preview' => ['home','properties','about','services','faq','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'barbershop-v1' => [
				'name' => 'Barbershop V1',
				'pages' => ['home','shop','barbers','schedule','services','blog','contact'],
				'preview' => ['home','shop','barbers','schedule','services','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'realestate-v3' => [
				'name' => 'Real Estate v3',
				'pages' => ['home','home-v2','about','directory','blog','contact'],
				'preview' => ['home','home-v2','about','directory','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'solar-energy-v1' => [
				'name' => 'Solar Energy 1',
				'pages' => ['home','about','services','detail-service','projects','team','blog','contact'],
				'preview' => ['home','about','services','detail-service','projects','team','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'solar-energy-v2' => [
				'name' => 'Solar Energy 2',
				'pages' => ['home','about-us','services','projects','team','faq','blog','contact,'],
				'preview' => ['home','about-us','services','projects','team','faq','blog','contact,'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'construction-v3' => [
				'name' => 'Construction v3',
				'pages' => ['home','home-v2','about','services','shop','blog','gallery','contact'],
				'preview' => ['home','home-v2','about','services','shop','blog','gallery','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'woo-auto-parts-v1' => [
				'name' => 'Auto Parts Store',
				'pages' => ['home','shop','about','blog','contact'],
				'preview' => ['home','shop','about','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'home-care-v1' => [
				'name' => 'Home Care',
				'pages' => ['home','about','appointment','services','blog','contact'],
				'preview' => ['home','about','appointment','services','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'fintech-v1' => [
				'name' => 'Fintech Startup',
				'pages' => ['home','about','services','blog','contact'],
				'preview' => ['home','about','services','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'fooddelivery-v1' => [
				'name' => 'Food Delivery',
				'pages' => ['home','services','blog','faq','contact'],
				'preview' => ['home','services','blog','faq','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'architecture-v2' => [
				'name' => 'Architecture',
				'pages' => ['home','about','projects','services','team','pricing','faq','contact'],
				'preview' => ['home','about','blog-architecture-v2','services','team','pricing','faq','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'architecture-v1' => [
				'name' => 'Architecture',
				'pages' => ['home','about','portfolio','services','faq','contact'],
				'preview' => ['home','about','portfolio','services','faq','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'drone-v1' => [
				'name' => 'Drone Project',
				'pages' => ['home','about','gallery','services','contact'],
				'preview' => ['/','about-us','gallery','services','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'medical-v1' => [
				'name' => 'Medical',
				'pages' => ['home','about','services','doctors','contact'],
				'preview' => ['home','about','services','doctors','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'job-listing-v1' => [
				'name' => 'Job Listing',
				'pages' => ['home','job-listing','about','blog','contact'],
				'preview' => ['home','job-listing','about','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'lawyer-v1' => [
				'name' => 'Lawyer',
				'pages' => ['home','practice','faq','reviews','attorney','contact'],
				'preview' => ['home','practice','faq','reviews','attorney','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'skincare-v1' => [
				'name' => 'Skin Care',
				'pages' => ['home','about','services','procedures','gallery','pricing','contact'],
				'preview' => ['home','about','services','procedures','gallery','pricing','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'travel-v1' => [
				'name' => 'Travel Blogger',
				'pages' => ['home','about','stories','contact'],
				'preview' => ['home','about','stories','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'pet-care-v1' => [
				'name' => 'Pet Care',
				'pages' => ['home','about','services','reviews','contact'],
				'preview' => ['home','about','services','reviews','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'pet-shop-v1' => [
				'name' => 'Pet Shop V1',
				'pages' => ['home','shop','cart','blog','about','contact'],
				'preview' => ['home','shop','cart','blog','about','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'car-repair-v1' => [
				'name' => 'Car Repair',
				'pages' => ['home','about','contact','services','team'],
				'preview' => ['home','about','contact','services','team'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'business-consulting-v1' => [
				'name' => 'Business Consulting',
				'pages' => ['home','about','blog','contact','services','contact','faq','history','pricing','team',],
				'preview' => ['home','about','blog','contact','services','contact','faq','history','pricing','team',],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'travel-blog-v1' => [
				'name' => 'Travel Blog',
				'pages' => ['home','home-v1','home-v2','about','contact'],
				'preview' => ['home','home-v2','home-v3','about','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'yoga-v1' => [
				'name' => 'Yoga',
				'pages' => ['home','about','classes','testimonials','contact'],
				'preview' => ['home','about','classes','testimonials','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'ecommerce-v1' => [
				'name' => 'Ecommerce',
				'pages' => ['home','shop','blog','about','contact'],
				'preview' => ['home','shop','blog','about','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'wooshop-v1' => [
				'name' => 'Woo Shop',
				'pages' => ['home','shop','about','contact'],
				'preview' => ['home','shop','about','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'fashion-v1' => [
				'name' => 'Fashion',
				'pages' => ['home','shop-v1','shop-v2','blog','about','faq','contact'],
				'preview' => ['home','shop-fashion-v1','shop-v2','blog','about','faq','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'woo-food-v1' => [
				'name' => 'Food Delivery',
				'pages' => ['home','home-v2','food','about','contact','faq','blog'],
				'preview' => ['home','home-woo-food-v2','shop-woo-food-v1','about','contact','faq','blog'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'estore-v1' => [
				'name' => 'Electronic Store',
				'pages' => ['home','shop','blog','faq','about','contact'],
				'preview' => ['home','shop','blog','faq','about','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'furniture-shop-v1' => [
				'name' => 'Furniture Shop',
				'pages' => ['home','shop-v1','shop-v2','about','contact'],
				'preview' => ['home','shop-furniture-shop-v1','shop-v2','about','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'restaurant-v1' => [
				'name' => 'Restaurant',
				'pages' => ['home','about','gallery','menu','contact'],
				'preview' => ['home','about','gallery','menu','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'grocery-store-v1' => [
				'name' => 'Grocery Store v1',
				'pages' => ['home','shop','about','contact'],
				'preview' => ['home','shop','about','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'grocery-store-v2' => [
				'name' => 'Grocery Store v2',
				'pages' => ['home','shop','cart','wishlist','compare','about','blog','contact','contact-v1','contact-v2'],
				'preview' => ['home','shop','cart','wishlist','compare','about','blog','contact','contact-v1','contact-v2'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'digital-marketing-agency-v1' => [
				'name' => 'Digital Marketing Agency',
				'pages' => ['home','seo','branding','marketing','social','about','contact'],
				'preview' => ['home','seo-services','branding','digital-marketing','social-media','about','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'digital-agency-dark-v1' => [
				'name' => 'Digital Agency Dark',
				'pages' => ['home','about','services','team','portfolio','blog','contact'],
				'preview' => ['home','about','services','team','portfolio','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'ittech-v1' => [
				'name' => 'IT Tech',
				'pages' => ['home','about','services','pricing','faq','contact'],
				'preview' => ['home','about-us','services','pricing','faq','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'cybersecurity-v1' => [
				'name' => 'Cybersecurity',
				'pages' => ['home','about','services','pricing','contact'],
				'preview' => ['home','about-us','services','pricing','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'developer-portfolio-v1' => [
				'name' => 'Developer Portfolio - v1',
				'pages' => ['home','portfolio','about','services','resume','contact'],
				'preview' => ['home','portfolio','about','services','resume','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'medical-v1' => [
				'name' => 'Medical',
				'pages' => ['home','about','services','doctors','contact'],
				'preview' => ['home','about-us','service','doctors','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'cryptocurrency-v1' => [
				'name' => 'Cryptocurrency',
				'pages' => ['home','about','services','token','pricing','contact'],
				'preview' => ['home','about-us','services','token','pricing','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'travel-agency-v1' => [
				'name' => 'Travel agency',
				'pages' => ['home','gallery','services','reviews','about','contact'],
				'preview' => ['home','gallery','services','reviews','about','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'digitalagency-v1' => [
				'name' => 'Digital Agency',
				'pages' => ['home','about','services','contact'],
				'preview' => ['home','about','services','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'digitalagency-v2' => [
				'name' => 'Digital Agency',
				'pages' => ['home','about','services','pricing','contact'],
				'preview' => ['home','about','services','pricing','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			// 'ittech-v2' => [ // Problem with links
			// 	'name' => 'IT Tech',
			// 	'pages' => ['home','about','services','pricing','faq','contact'],
			// 	'preview' => ['home','about-us','services','pricing','faq','contact'],
			// 	'price' => $is_pro_active ? 'free' : 'pro',
			// ],
			'nft-portfolio-v1' => [
				'name' => 'NFT',
				'pages' => ['home','about','roadmap','team','nft','faq','comingsoon'],
				'preview' => ['home','about','roadmap','team','nft','faq','coming-soon'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'construction-v1' => [
				'name' => 'Construction v1',
				'pages' => ['home','about','services','projects','pricing','contact','faq'],
				'preview' => ['home','about','services','projects','pricing','contact','faq'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'construction-v2' => [
				'name' => 'Construction v2',
				'pages' => ['home','about','services','projects','contact'],
				'preview' => ['home','about','services','projects','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'photographer-v1' => [
				'name' => 'Photographer Dark',
				'pages' => ['home','about','services','portfolio','contact'],
				'preview' => ['home','about','services','portfolio','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'photographer-v2' => [
				'name' => 'Photographer Light',
				'pages' => ['home','about','services','portfolio','contact'],
				'preview' => ['home','about','services','portfolio','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'hotel-v1' => [
				'name' => 'Hotel',
				'pages' => ['home','dining','rooms','services','history','gallery','contact'],
				'preview' => ['home','dining','rooms','services','history','gallery','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'digital-seo-marketing-agency-v1' => [
				'name' => 'Digital SEO Agency v1',
				'pages' => ['home','about','services','team','projects','details','pricing','blog','faq','contact'],
				'preview' => ['home','about','services','team','projects','project-details','pricing','blog','faq','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'digital-seo-marketing-agency-v2' => [
				'name' => 'Digital SEO Agency v2',
				'pages' => ['home','about','solutions','awards','careers','work','email-marketing','paid-search-marketing','search-engine-optimization','contact','blog'],
				'preview' => ['home','about','solutions','awards','careers','work','email-marketing','paid-search-marketing','search-engine-optimization','contact','blog'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'fitness-gym-v1' => [
				'name' => 'Fitness Gym',
				'pages' => ['home','about','gallery','classes','pricing','review','trainers','blog','contact','comingsoon'],
				'preview' => ['home','about','gallery','classes','pricing','review','trainers','blog','contact','coming-soon'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'wedding-v1' => [
				'name' => 'Wedding',
				'pages' => ['home','about','services','blog','gallery','contact'],
				'preview' => ['home','about','services','blog','gallery','rsvp'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'school-v1' => [
				'name' => 'School - V1',
				'pages' => ['home','about','classes','class-details','teachers','teacher-details','events','event-details','blog','gallery','contact'],
				'preview' => ['home','about','classes','class-details','teachers','teacher-details','events','event-details','blog','gallery','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'portfolio-v1' => [
				'name' => 'Portfolio/CV',
				'pages' => ['home','about','portfolio','contact'],
				'preview' => ['home','about','portfolio','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'jewelry-v1' => [
				'name' => 'Jewelry Shop',
				'pages' => ['home','shop','cart','compare','wishlist','about','about-me','faq','blog','contact'],
				'preview' => ['home','shop','cart','compare','wishlist','about','about-me','faq','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'travel-v3' => [
				'name' => 'Travel V3',
				'pages' => ['home','about','tours','tours-details','gallery','blog','contact'],
				'preview' => ['home','about','tours','tours-details','gallery','blog','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'pizza-v1' => [
				'name' => 'Pizza Restaurant',
				'pages' => ['home','menu','about','offer','gallery','contact'],
				'preview' => ['home','menu','about','offer','gallery','contact'],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'winebar-v1' => [
				'name' => 'Wine Bar',
				'pages' => ['home','story','wines','dishes','events','contact'],
				'preview' => ['home','our-story','wines','dishes','event','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
			'charity-v1' => [
				'name' => 'Charity',
				'pages' => ['home','contact','whatwedo','whoweare','partners',],
				'preview' => ['home','contact','what-we-do','who-wea-re','our-partners',],
				'price' => $is_pro_active ? 'free' : 'pro',
			],
			'carwash-v1' => [
				'name' => 'Carwash',
				'pages' => ['home','about','services','contact'],
				'preview' => ['home','about','services','contact'],
				'price' => $is_pro_active ? 'free' : 'free',
			],
		];
	}
	
	public static function get_available_sections() {
		return [
			'Header' => [
				'1',
				'2-pro',
				'3',
				'4',
				'5',
				'6-pro',
				'7-pro',
				'8',
				'9',
				'10-pro',
				'11-pro',
				'12',
				'13-pro',
				'14-pro',
				'15',
				'16-pro',
				'17',
				'18',
				'19-pro',
				'20-woo',
				'21-woo-pro',
				'22-woo-pro',
				'23-woo-pro',
				'24-woo-pro',
				'25-woo-pro',
				'26',
				'27-pro',
				'28',
				'29-pro',
				'30-pro',
				'31-woo-pro',
				'32-pro',
				'33-woo-pro',
				'34-pro',
				'35',
				'36-woo-pro',
			],
			'Footer' => [
				'1',
				'2-pro',
				'3',
				'4',
				'5',
				'6',
				'7',
				'8-pro',
				'9-pro',
				'10',
				'11',
				'12',
				'13',
				'14',
				'15-pro',
				'16-pro',
				'17-pro',
				'18',
				'19',
				'20-pro',
				'21-pro',
				'22-pro',
				'23',
				'24-pro',
				'25',
				'26-pro',
				'27',
				'28-pro',
				'29-pro',
				'30-pro',
				'31-pro',
				'32-pro',
			],
			'Services' => [
				'1',
                '2-pro',
                '3',
                '4',
                '5',
                '6',
                '7-pro',
                '8-pro',
                '9',
                '10',
                '11',
                '12-pro',
                '13',
                '14',
                '15',
                '16',
                '17',
                '18',
                '19',
                '20',
                '21-pro',
                '22-pro',
                '23-pro',
                '24',
                '25-pro',
                '26-pro',
                '27',
                '28-pro',
                '29',
                '30-pro',
                '31-pro',
			],
			'FAQ' => [
				'1',
				'2-pro',
				'3',
				'4',
				'5',
				'6-pro',
				'7-pro',
				'8',
				'9',
				'10',
				'11',
				'12',
				'13',
				'14',
				'15',
				'16-pro',
				'17-pro',
				'18',
				'19-pro',
				'20-pro',
				'21-pro',
				'22',
				'23-pro',
				'24',
				'25-pro',
				'26-pro',
				'27',
				'28-pro',
				'29',
				'30',
			],
			'Hero Slider' => [
				'1',
				'2-pro',
				'3',
				'4',
				'5-pro',
				'6',
				'7-pro',
				'8-pro',
				'9',
				'10-pro',
				'11-pro',
				'12-pro',
				'13-pro',
				'14-pro',
				'15',
				'16-pro',
				'17-pro',
				'18',
				'19',
				'20',
			],
			'Hero Section' => [
				'1',
				'2-pro',
				'3',
				'4',
				'5-pro',
				'6',
				'7',
				'8',
				'9',
				'10',
				'11',
				'12',
				'13-pro',
				'14-pro',
				'15-pro',
				'16',
				'17-pro',
				'18',
				'19-pro',
				'20-pro',
				'21',
				'22',
				'23',
				'24',
				'25',
				'26',
				'27',
				'28-pro',
				'29-pro',
				'30-pro',
			],
		];
	}

	public static function get_available_blocks() {
		return [
			'grid' => [
				'v1' => ['type' => 'iframe', 'url' => 'grid/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'grid/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'grid/v3/'],
				'v4' => ['type' => 'iframe', 'url' => 'grid/v4/'],
				'v5-pro' => ['type' => 'iframe', 'url' => 'grid/v5/'],
				'v6-pro' => ['type' => 'iframe', 'url' => 'grid/v6/'],
				'v7-pro' => ['type' => 'iframe', 'url' => 'grid/v7/'],
				'v8-pro' => ['type' => 'iframe', 'url' => 'grid/v8/'],
				'v9-pro' => ['type' => 'iframe', 'url' => 'grid/v9/'],
				'v10-pro' => ['type' => 'iframe', 'url' => 'grid/v10/'],
				'v11' => ['type' => 'iframe', 'url' => 'grid/v11/'],
				'v12' => ['type' => 'iframe', 'url' => 'grid/v12/'],
				'v13' => ['type' => 'iframe', 'url' => 'grid/v13/'],
				'v14' => ['type' => 'iframe', 'url' => 'grid/v14/'],
			],
			'woo-grid' => [
				'v1' => ['type' => 'iframe', 'url' => 'woocommerce-grid/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'woocommerce-grid/v2/'],
				'v3-pro' => ['type' => 'iframe', 'url' => 'woocommerce-grid/v3/'],
				'v4-pro' => ['type' => 'iframe', 'url' => 'woocommerce-grid/v4/'],
				'v5-pro' => ['type' => 'iframe', 'url' => 'woocommerce-grid/v5/'],
				'v6-pro' => ['type' => 'iframe', 'url' => 'woocommerce-grid/v6/'],
				'v7-pro' => ['type' => 'iframe', 'url' => 'woocommerce-grid/v7/'],
				'v8-pro' => ['type' => 'iframe', 'url' => 'woocommerce-grid/v8/'],
				'v9-pro' => ['type' => 'iframe', 'url' => 'woocommerce-grid/v9/'],
			],
			'form-builder' => [
				'v1' => ['type' => 'iframe', 'url' => 'form-builder/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'form-builder/v2/'],
				'v3-pro' => ['type' => 'iframe', 'url' => 'form-builder/v3/'],
				'v4-pro' => ['type' => 'iframe', 'url' => 'form-builder/v4/'],
				'v5-pro' => ['type' => 'iframe', 'url' => 'form-builder/v5/'],
			],
			'media-grid' => [
				'v1' => ['type' => 'iframe', 'url' => 'image-grid/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'image-grid/v2/'],
			],
			'magazine-grid' => [
				'v1' => ['type' => 'iframe', 'url' => 'magazine-grid/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'magazine-grid/v2/'],
				// 'v3' => ['type' => 'iframe', 'url' => 'magazine-grid/v3/', 'sub' => 'carousel'], <-- Keep as example
				'v3-pro' => ['type' => 'iframe', 'url' => 'magazine-grid/v3/'],
				'v4-pro' => ['type' => 'iframe', 'url' => 'magazine-grid/v4/'],
				'v5-pro' => ['type' => 'iframe', 'url' => 'magazine-grid/v5/'],
				'v6-pro' => ['type' => 'iframe', 'url' => 'magazine-grid/v6/'],
				'v7-pro' => ['type' => 'iframe', 'url' => 'magazine-grid/v7/'],
				'v8-pro' => ['type' => 'iframe', 'url' => 'magazine-grid/v8/'],
			],
			'advanced-slider' => [
				'v1' => ['type' => 'iframe', 'url' => 'advanced-slider/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'advanced-slider/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'advanced-slider/v3/'],
				'v4-pro' => ['type' => 'iframe', 'url' => 'advanced-slider/v4/'],
				'v5-pro' => ['type' => 'iframe', 'url' => 'advanced-slider/v5/'],
				'v6-pro' => ['type' => 'iframe', 'url' => 'advanced-slider/v6/'],
				'v7-pro' => ['type' => 'iframe', 'url' => 'advanced-slider/v7/'],
				'v8-pro' => ['type' => 'iframe', 'url' => 'advanced-slider/v8/'],
			],
			'posts-timeline' => [
				'v1' => ['type' => 'iframe', 'url' => 'timeline/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'timeline/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'timeline/v3/'],
				'v4' => ['type' => 'iframe', 'url' => 'timeline/v4/'],
				'v5' => ['type' => 'iframe', 'url' => 'timeline/v5/'],
			],
			'testimonial' => [
				'v1' => ['type' => 'iframe', 'url' => 'testimonial-slider/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'testimonial-slider/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'testimonial-slider/v3/'],
				'v4' => ['type' => 'iframe', 'url' => 'testimonial-slider/v4/'],
				'v5-pro' => ['type' => 'iframe', 'url' => 'testimonial-slider/v5/'],
				'v6-pro' => ['type' => 'iframe', 'url' => 'testimonial-slider/v6/'],
				'v7-pro' => ['type' => 'iframe', 'url' => 'testimonial-slider/v7/'],
				'v8-pro' => ['type' => 'iframe', 'url' => 'testimonial-slider/v8/'],
				'v9-pro' => ['type' => 'iframe', 'url' => 'testimonial-slider/v9/'],
			],
			'nav-menu' => [
				'v1' => ['type' => 'iframe', 'url' => 'nav-menu/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'nav-menu/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'nav-menu/v3/'],
				'v4' => ['type' => 'iframe', 'url' => 'nav-menu/v4/'],
				'v5' => ['type' => 'iframe', 'url' => 'nav-menu/v5/'],
				'v6' => ['type' => 'iframe', 'url' => 'nav-menu/v6/'],
			],
			'onepage-nav' => [
				'v1' => ['type' => 'iframe', 'url' => 'one-page-navigation/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'one-page-navigation/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'one-page-navigation/v3/'],
				'v4-pro' => ['type' => 'iframe', 'url' => 'one-page-navigation/v4/'],
			],
			'pricing-table' => [
				'v1' => ['type' => 'iframe', 'url' => 'pricing-table/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'pricing-table/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'pricing-table/v3/'],
				'v4' => ['type' => 'iframe', 'url' => 'pricing-table/v4/'],
				'v5' => ['type' => 'iframe', 'url' => 'pricing-table/v5/'],
				'v6-pro' => ['type' => 'iframe', 'url' => 'pricing-table/v6/'],
				'v7-pro' => ['type' => 'iframe', 'url' => 'pricing-table/v7/'],
				'v8-pro' => ['type' => 'iframe', 'url' => 'pricing-table/v8/'],
			],
			'content-toggle' => [
				'v1' => ['type' => 'iframe', 'url' => 'content-toggle/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'content-toggle/v2/'],
				'v3-pro' => ['type' => 'iframe', 'url' => 'content-toggle/v3/'],
				'v4-pro' => ['type' => 'iframe', 'url' => 'content-toggle/v4/'],
			],
			'data-table' => [
				'v1' => ['type' => 'iframe', 'url' => 'data-table/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'data-table/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'data-table/v3/'],
				'v4-pro' => ['type' => 'iframe', 'url' => 'data-table/v4/'],
				'v5-pro' => ['type' => 'iframe', 'url' => 'data-table/v5/'],
				'v6-pro' => ['type' => 'iframe', 'url' => 'data-table/v6/'],
				'v7-pro' => ['type' => 'iframe', 'url' => 'data-table/v7/'],
				'v8-pro' => ['type' => 'iframe', 'url' => 'data-table/v8/'],
			],
			'countdown' => [
				'v1' => ['type' => 'iframe', 'url' => 'countdown/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'countdown/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'countdown/v3/'],
			],
			'progress-bar' => [
				'v1' => ['type' => 'iframe', 'url' => 'progress-bar/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'progress-bar/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'progress-bar/v3/'],
			],
			'instagram-feed' => [
				'v1-pro' => ['type' => 'iframe', 'url' => 'instagram-feed/v1/'],
				'v2-pro' => ['type' => 'iframe', 'url' => 'instagram-feed/v2/'],
				'v3-pro' => ['type' => 'iframe', 'url' => 'instagram-feed/v3/'],
				'v4-pro' => ['type' => 'iframe', 'url' => 'instagram-feed/v4/'],
				'v5-pro' => ['type' => 'iframe', 'url' => 'instagram-feed/v5/'],
				'v6-pro' => ['type' => 'iframe', 'url' => 'instagram-feed/v6/'],
			],
			'tabs' => [
				'v1' => ['type' => 'iframe', 'url' => 'tabs/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'tabs/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'tabs/v3/'],
			],
			'advanced-text' => [
				'v1' => ['type' => 'iframe', 'url' => 'advanced-text/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'advanced-text/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'advanced-text/v3/'],
				'v4' => ['type' => 'iframe', 'url' => 'advanced-text/v4/'],
				'v5' => ['type' => 'iframe', 'url' => 'advanced-text/v5/'],
				'v6' => ['type' => 'iframe', 'url' => 'advanced-text/v6/'],
				'v7-pro' => ['type' => 'iframe', 'url' => 'advanced-text/v7/'],
				'v8-pro' => ['type' => 'iframe', 'url' => 'advanced-text/v8/'],
				'v9-pro' => ['type' => 'iframe', 'url' => 'advanced-text/v9/'],
				'v10-pro' => ['type' => 'iframe', 'url' => 'advanced-text/v10/'],
				'v11-pro' => ['type' => 'iframe', 'url' => 'advanced-text/v11/'],
				'v12-pro' => ['type' => 'iframe', 'url' => 'advanced-text/v12/'],
			],
			'flip-box' => [
				'v1' => ['type' => 'iframe', 'url' => 'flip-box/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'flip-box/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'flip-box/v3/'],
				'v4-pro' => ['type' => 'iframe', 'url' => 'flip-box/v4/'],
			],
			'promo-box' => [
				'v1' => ['type' => 'iframe', 'url' => 'promo-box/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'promo-box/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'promo-box/v3/'],
				'v4-pro' => ['type' => 'iframe', 'url' => 'promo-box/v4/'],
				'v5-pro' => ['type' => 'iframe', 'url' => 'promo-box/v5/'],
				'v6-pro' => ['type' => 'iframe', 'url' => 'promo-box/v6/'],
			],
			'before-after' => [
				'v1' => ['type' => 'iframe', 'url' => 'before-and-after/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'before-and-after/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'before-and-after/v3/'],
			],
			'image-hotspots' => [
				'v1' => ['type' => 'iframe', 'url' => 'image-hotspot/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'image-hotspot/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'image-hotspot/v3/'],
			],
			'forms' => [],
			'mailchimp' => [
				'v1' => ['type' => 'iframe', 'url' => 'mailchimp/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'mailchimp/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'mailchimp/v3/'],
				'v4' => ['type' => 'iframe', 'url' => 'mailchimp/v4/'],
				'v5' => ['type' => 'iframe', 'url' => 'mailchimp/v5/'],
				'v6-pro' => ['type' => 'iframe', 'url' => 'mailchimp/v6/'],
				'v7-pro' => ['type' => 'iframe', 'url' => 'mailchimp/v7/'],
				'v8-pro' => ['type' => 'iframe', 'url' => 'mailchimp/v8/'],
			],
			'content-ticker' => [
				'v1' => ['type' => 'iframe', 'url' => 'content-ticker/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'content-ticker/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'content-ticker/v3/'],
				'v4-pro' => ['type' => 'iframe', 'url' => 'content-ticker/v4/'],
				'v5-pro' => ['type' => 'iframe', 'url' => 'content-ticker/v5/'],
				'v6-pro' => ['type' => 'iframe', 'url' => 'content-ticker/v6/'],
			],
			'button' => [
				'v1' => ['type' => 'iframe', 'url' => 'button/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'button/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'button/v3/'],
				'v4' => ['type' => 'iframe', 'url' => 'button/v4/'],
				'v5' => ['type' => 'iframe', 'url' => 'button/v5/'],
			],
			'dual-button' => [
				'v1' => ['type' => 'iframe', 'url' => 'dual-button/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'dual-button/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'dual-button/v3/'],
			],
			'team-member' => [
				'v1' => ['type' => 'iframe', 'url' => 'team-member/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'team-member/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'team-member/v3/'],
				'v4' => ['type' => 'iframe', 'url' => 'team-member/v4/'],
				'v5' => ['type' => 'iframe', 'url' => 'team-member/v5/'],
				'v6-pro' => ['type' => 'iframe', 'url' => 'team-member/v6/'],
				'v7-pro' => ['type' => 'iframe', 'url' => 'team-member/v7/'],
				'v8-pro' => ['type' => 'iframe', 'url' => 'team-member/v8/'],
			],
			'google-maps' => [
				'v1' => ['type' => 'iframe', 'url' => 'google-map/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'google-map/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'google-map/v3/'],
				'v4' => ['type' => 'iframe', 'url' => 'google-map/v4/'],
				'v5' => ['type' => 'iframe', 'url' => 'google-map/v5/'],
			],
			'price-list' => [
				'v1' => ['type' => 'iframe', 'url' => 'price-list/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'price-list/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'price-list/v3/'],
				'v4-pro' => ['type' => 'iframe', 'url' => 'price-list/v4/'],
				'v5-pro' => ['type' => 'iframe', 'url' => 'price-list/v5/'],
				'v6-pro' => ['type' => 'iframe', 'url' => 'price-list/v6/'],
				'v7-pro' => ['type' => 'iframe', 'url' => 'price-list/v7/'],
			],
			'business-hours' => [
				'v1' => ['type' => 'iframe', 'url' => 'business-hours/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'business-hours/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'business-hours/v3/'],
			],
			'sharing-buttons' => [
				'v1' => ['type' => 'iframe', 'url' => 'sharing-button/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'sharing-button/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'sharing-button/v3/'],
				'v4-pro' => ['type' => 'iframe', 'url' => 'sharing-button/v4/'],
				'v5-pro' => ['type' => 'iframe', 'url' => 'sharing-button/v5/'],
			],
			'logo' => [],
			'search' => [
				'v1' => ['type' => 'iframe', 'url' => 'search/v1/'],
				'v2' => ['type' => 'iframe', 'url' => 'search/v2/'],
				'v3' => ['type' => 'iframe', 'url' => 'search/v3/'],
			],
			'phone-call' => [],
			'back-to-top' => [],
			'lottie-animations' => [],
			'popup-trigger' => [],
		];
	}

	public static function get_available_popups() {
		return [
			// 'contact' => [
			// 	'v1' => ['type' => 'iframe', 'url' => 'search/v1/'],
			// 	'v2' => ['type' => 'iframe', 'url' => 'search/v2/'],
			// 	'v3' => ['type' => 'iframe', 'url' => 'search/v3/'],
			// ],
			'cookie' => [
				'v1' => ['type' => 'image', 'url' => 'popups/cookie/v1-preview.jpg'],
				'v2-pro' => ['type' => 'image', 'url' => 'popups/cookie/v2-pro-preview.jpg'],
				'v3-pro' => ['type' => 'image', 'url' => 'popups/cookie/v3-pro-preview.jpg'],
				'v4-pro' => ['type' => 'image', 'url' => 'popups/cookie/v4-pro-preview.jpg'],
			],
			'discount' => [
				'v1' => ['type' => 'image', 'url' => 'popups/discount/v1-preview.jpg'],
				'v2' => ['type' => 'image', 'url' => 'popups/discount/v2-preview.jpg'],
				'v3-pro' => ['type' => 'image', 'url' => 'popups/discount/v3-pro-preview.jpg'],
				'v4-pro' => ['type' => 'image', 'url' => 'popups/discount/v4-pro-preview.jpg'],
				'v5' => ['type' => 'image', 'url' => 'popups/discount/v5-preview.jpg'],
				'v6' => ['type' => 'image', 'url' => 'popups/discount/v6-preview.jpg'],
				'v7-pro' => ['type' => 'image', 'url' => 'popups/discount/v7-pro-preview.jpg'],
				'v8-pro' => ['type' => 'image', 'url' => 'popups/discount/v8-pro-preview.jpg'],
				'v9' => ['type' => 'image', 'url' => 'popups/discount/v9-preview.jpg'],
				'v10' => ['type' => 'image', 'url' => 'popups/discount/v10-preview.jpg'],
				'v11-pro' => ['type' => 'image', 'url' => 'popups/discount/v11-pro-preview.jpg'],
				'v12-pro' => ['type' => 'image', 'url' => 'popups/discount/v12-pro-preview.jpg'],
				'v13-pro' => ['type' => 'image', 'url' => 'popups/discount/v13-pro-preview.jpg'],
				'v14' => ['type' => 'image', 'url' => 'popups/discount/v14-preview.jpg'],
				'v15' => ['type' => 'image', 'url' => 'popups/discount/v15-preview.jpg'],
				'v16-pro' => ['type' => 'image', 'url' => 'popups/discount/v16-pro-preview.jpg'],
			],
			'subscribe' => [
                'v1-pro' => ['type' => 'image', 'url' => 'popups/subscribe/v1-pro-preview.jpg'],  
			    'v2-pro' => ['type' => 'image', 'url' => 'popups/subscribe/v2-pro-preview.jpg'],
				'v3-pro' => ['type' => 'image', 'url' => 'popups/subscribe/v3-pro-preview.jpg'],
		    ],
			'yesno' => [
				'v1-pro' => ['type' => 'image', 'url' => 'popups/yesno/v1-pro-preview.jpg'],  
			    'v2-pro' => ['type' => 'image', 'url' => 'popups/yesno/v2-pro-preview.jpg'],
				'v3-pro' => ['type' => 'image', 'url' => 'popups/yesno/v3-pro-preview.jpg'],
			],
		];
	}
}